package com.zjty.inspect.service;

import com.zjty.inspect.entity.Page;
import com.zjty.inspect.entity.RuleCollection;
import com.zjty.inspect.entity.RuleQo;

import java.util.List;
import java.util.Map;

/**
 * 规则接口
 */
public interface RuleService {

    /**
     * 新增规则
     * @param ruleQo 规则封装类
     */
    public void addRule(RuleQo ruleQo);
    /**
     * 修改规则
     * @param ruleQo 规则封装类
     */
    public void upRule(RuleQo ruleQo);

    /**
     * 删除规则
     * @param ruleQo 规则封装类
     */
    public void deleteRule(RuleQo ruleQo);

    /**
     * 查询所有规则
     * @return 规则
     */
    List<RuleCollection> findAll();

    List<RuleCollection> findByName(String name);

    Page<RuleCollection> findSearch(Map searchMap, int page, int size);
}
