package com.zjty.inspect.thread.pool;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * @program: bserver-parent
 * @description: 线程池属性配置类
 * @author: LiuJie
 * @create: 2019-05-20 16:01
 **/
@Data
@Configuration
//@ConfigurationProperties(prefix = "thread.pool")
public class ThreadPoolConfig {
    /**
     * 核心线程池大小
     */
    @Value("${thread.pool.corePoolSize}")
    private int corePoolSize;
    /**
     * 最大线程数
     */
    @Value("${thread.pool.maxPoolSize}")
    private int maxPoolSize;
    /**
     * 活跃时间
     */
    @Value("${thread.pool.keepAliveSeconds}")
    private int keepAliveSeconds;
    /**
     * 队列容量
     */
    @Value("${thread.pool.queueCapacity}")
    private int queueCapacity;
}
