package com.zjty.inspect.entity;

import com.zjty.inspect.enums.CompatibleBrowser;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * <h4>Description : 前端浏览器相关</h4>
 *
 * @author : czq
 * @Date : 2020-03-05 17:22
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "前端浏览器相关")
public class Browser {

    /**
     * 兼容的浏览器
     */
    private List<CompatibleBrowser> compatibleBrowsers;
    /**
     * 浏览器插件
     */
    private List<BaseDes> browserPlugs;

    /**
     * 插件安装情况int 1：是 2：否
     */
    @ApiModelProperty(value = "插件安装情况int",example = "1")
    private Integer PlugInUnit = -1;

    /**
     * 其他兼容的浏览器
     */
    private String otherBrowser;


    /*
    更多需求
     */

    /**
     * 地理信息系统 int 1：是 2：否
     */
    @ApiModelProperty(value = "地理信息系统",example = "1")
    private Integer geography = -1;
    /**
     * 调用外设
     */
    @ApiModelProperty(value = "调用外设",example = "1")
    private Integer peripheral = -1;

    /**
     *动画
     */
    @ApiModelProperty(value = "动画",example = "1")
    private Integer animation = -1;

    /**
     * 3d展示
     */
    @ApiModelProperty(value = "3d展示",example = "1")
    private Integer threeD = -1;

    /**
     * 公文显现与编辑
     */
    @ApiModelProperty(value = "公文显现与编辑",example = "1")
    private Integer document = -1;

    /**
     * 多媒体
     */
    @ApiModelProperty(value = "多媒体",example = "1")
    private Integer media = -1;

    /**
     * Flash
     */
    @ApiModelProperty(value = "Flash",example = "1")
    private Integer flash = -1;

    /**
     * 其他
     */
    @ApiModelProperty(value = "其他",example = "1")
    private Integer otherDemand = -1;
}
