package com.zjty.inspect.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 依赖树
 * @author Mcj
 * @date 2020-02-18 11:19
 */
@Data
@ApiModel(value = "依赖树")
public class DepTree implements Serializable {


    private String depName;
    private List<DepTree> depTreeList = new ArrayList<>();

    /**
     * 0,未违规
     * 1,违规
     */
    @ApiModelProperty(value = "未违规",example = "0")
    private Integer violation = 0;
}
