package com.zjty.inspect.entity;

import io.swagger.annotations.ApiModel;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@ApiModel(value = "bs浏览器技术名称")
@Getter
public enum  FontTechnologyEnum {
    BUSHEJI("不涉及",1),
    WU("无",-1),
    JS("JS",2),
    CSS("CSS",3),
    ASP("ASP",4),
    HTML("HTML",5),
    JQUERY("JQUERY框架",6),
    SPRING("SPRING框架",7),
    ANGULAR("ANGULAR框架",8),
    VUE("VUE框架",9),
    REACT("REACT框架",10),
    QUCIK("QUCIKUI框架",11),
    LAY("LAYUI框架",12),
    AVALON("AVALON框架",13),
    EMBER("EMBER框架",14),
    AURELIA("AURELIA框架",15),
    QITA("其他",16);
    //描述
    private String name;
    //序号
    private Integer code;

    FontTechnologyEnum() {
    }
    private static Map<String,FontTechnologyEnum> fontTechnologyEnumMap=new HashMap<>();
    static {
        for (FontTechnologyEnum fontTechnologyEnum : FontTechnologyEnum.values()) {
            fontTechnologyEnumMap.put(fontTechnologyEnum.getName(),fontTechnologyEnum);
        }
    }
    FontTechnologyEnum(String name, int code) {
        this.name = name;
        this.code = code;
    }

    public static FontTechnologyEnum getByName(String name){
        FontTechnologyEnum fontTechnologyEnum = fontTechnologyEnumMap.get(name);
        if(fontTechnologyEnum == null){
            return QITA;
        }
        return fontTechnologyEnum;
    }
}
