package com.zjty.inspect.entity;

import io.swagger.annotations.ApiModel;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@ApiModel(value = "架构类型")
@Getter
public enum  FrameWorkEnum {
    WU(-1,"无"),
    NET(1,".NET体系下的框架"),
    JEE(2,"J2EE体系下的框架"),
    PHP(3,"THINKPHP"),
    YII(4,"YII"),
    CODEIGNITER(5,"CODEIGNITER"),
    LARAVEL(6,"LARAVEL"),
    DJANGO(7,"DJANGO"),
    TORNADO(8,"TORNADO"),
    FLASK(9,"FLASK"),
    TWISTED(10,"TWISTED"),
    SCRAPY(11,"SCRAPY"),
    BOTTLE(12,"BOTTLE"),
    WEBPY(13,"WEBPY"),
    FALCON(14,"FALCON"),
    QITA(15,"其他");

    private Integer code;
    private String name;
    FrameWorkEnum() {
    }
    private static Map<String,FrameWorkEnum> frameWorkEnumMap=new HashMap<>();
    static {
        for (FrameWorkEnum frameWorkEnum : FrameWorkEnum.values()) {
            frameWorkEnumMap.put(frameWorkEnum.getName(),frameWorkEnum);
        }
    }
    FrameWorkEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static FrameWorkEnum getByName(String name){
        FrameWorkEnum frameWorkEnum = frameWorkEnumMap.get(name);
        if(frameWorkEnum == null){
            return QITA;
        }
        return frameWorkEnum;
    }
}
