package com.zjty.inspect.entity;

import io.swagger.annotations.ApiModel;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@ApiModel(value = "其他语言枚举类")
@Getter
public enum  LanguageEnum {
    WU(-1,"无"),
    C(1,"VC/C++/C#"),
    VB(2,"VB"),
    DELPHI(3,"DELPHI"),
    PHP(4,"PHP"),
    JAVA(5,"JAVA"),
    PYTHON(6,"PYTHON"),
    GO(7,"GO"),
    RUST(8,"RUST"),
    RUBY(9,"RUBY"),
    PERL(10,"PERL"),
    MATLAB(11,"MATLAB"),
    QITA(12,"其他");


    private Integer code;
    private String name;

    LanguageEnum() {
    }
    private static Map<String,LanguageEnum> languageEnumMap=new HashMap<>();
    static {
        for (LanguageEnum languageEnum : LanguageEnum.values()) {
            languageEnumMap.put(languageEnum.getName(),languageEnum);
        }
    }
    LanguageEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static LanguageEnum getByName(String name){
        LanguageEnum languageEnum = languageEnumMap.get(name);
        if(languageEnum == null){
            return QITA;
        }
        return languageEnum;
    }
}
