package com.zjty.inspect.entity;

import io.swagger.annotations.ApiModel;
import lombok.Getter;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@ApiModel(value = "微服务")
@Getter
public enum MicroServiceEnum {
    NONE(-1,"无"),
    FLUME(0,"FLUME"),
    ZOOKEEPER(1,"ZOOKEEPER"),
    RIBBON(2,"RIBBON"),
    HYSTIX(3,"HYSTIX"),
    HBASE(4,"HBASE"),
    HIVE(5,"HIVE"),
    SPARKSTROM(6,"SPARK STROM"),
    RESTTEMPLATE(7,"RESTTEMPLATE"),
    KVM(8,"KVM"),
    OPENSTACK(9,"OPENSTACK"),
    KUBERNETES(10,"KUBERNETES"),
    DOCKER(11,"DOCKER"),
    EXMOBI(12,"EXMOBI"),
    DATAV(13,"DATAV"),
    RAYDATA(14,"RAYDATA"),
    BIANMU(15,"编目服务"),
    DITU(16,"地图类微服务"),
    TUBIAO(17,"图表视图类微服务"),
    SHIBIE(18,"识别类微服务"),
    NEIRONG(19,"内容审查类微服务"),
    FENXI(20,"智能分析类微服务"),
    DATA(21,"数据引用类微服务"),
    IOQUICK(22,"流媒体加速类微服务"),
    JIAMI(23,"加密类微服务"),
    OTHER(24,"其他");
    private Integer code;
    private String name;

    MicroServiceEnum() {
    }
    private static Map<String,MicroServiceEnum> microServiceEnumMap=new HashMap<>();
    static {
        for (MicroServiceEnum microServiceEnum : MicroServiceEnum.values()) {
            microServiceEnumMap.put(microServiceEnum.getName(),microServiceEnum);
        }
    }
    MicroServiceEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }
    public static MicroServiceEnum getByName(String name){
        MicroServiceEnum microServiceEnum = microServiceEnumMap.get(name);
        if(microServiceEnum == null){
            return OTHER;
        }
        return microServiceEnum;
    }
}
