package com.zjty.inspect.entity;

import io.swagger.annotations.ApiModel;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@ApiModel(value = "打包方式")
@Getter
public enum OpgaEnum {
    WU(-1,"无"),
    SETUPINSHEILD(-1,"SETUP/INSTALLSHEILD封装"),
    MAVEN(-1,"MAVEN打包方式"),
    GRADLE(-1,"GRADLE打包方式"),
    QITA(-1,"其他");

    private Integer code;
    private String name;
    private static Map<String,OpgaEnum> opgaEnumMap=new HashMap<>();
    static {
        for (OpgaEnum opgaEnum : OpgaEnum.values()) {
            opgaEnumMap.put(opgaEnum.getName(),opgaEnum);
        }
    }
    OpgaEnum() {
    }

    OpgaEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static OpgaEnum getByName(String name){
        OpgaEnum opgaEnum = opgaEnumMap.get(name);
        if(opgaEnum == null){
            return OpgaEnum.QITA;
        }
        return opgaEnum;
    }
}
