package com.zjty.inspect.enums;


import com.zjty.inspect.entity.FontTechnologyEnum;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * <h4>Description : 兼容的浏览器</h4>
 *
 * @author : czq
 * @Date : 2020-03-05 17:25
 */
@Getter
public enum CompatibleBrowser {

    SANLIUL(1, "360安全浏览器（Trident/Blink内核）"),
    SAFARI(2, "Safari（webkit内核）"),
    OTHER(3, "其他：请在备注中填写,如需填写多个,请以逗号分隔"),
    IETRIDENT(4, "IE（Trident内核）"),
    CHROMEWEBKIT(5, "Chrome（Webkit/Blink内核）"),
    CHROMIUM(6, "Chrome（Chromium内核）"),
    FIREFOX(7, "Firefox（Gecko内核）"),
    OPERA(8, "Opera（Blink内核）"),
    SECURE(9, "secure"),
    NONE(-1, "none");

    private Integer code;
    private String name;

    CompatibleBrowser() {
    }
    private static Map<String, CompatibleBrowser> compatibleBrowserMap=new HashMap<>();
    static {
        for (CompatibleBrowser compatibleBrowser : CompatibleBrowser.values()) {
            compatibleBrowserMap.put(compatibleBrowser.getName(),compatibleBrowser);
        }
    }
    CompatibleBrowser(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static CompatibleBrowser getByName(String name) {
        CompatibleBrowser compatibleBrowser = compatibleBrowserMap.get(name);
        if (compatibleBrowser == null) {
            return NONE;
        }
        return compatibleBrowser;
    }
}