package com.zjty.inspect.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * <h4>Description : inspect</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2020-03-05 18:02
 */
@Getter
public enum DatabaseType {
    ACCESS(1,"ACCESS"),
    POSTGRESQL(2,"PostgreSQL"),
    SQLSERVER(3,"SQL Server"),
    ORACLE(4,"Oracle"),
    MYSQL(5,"MySQL"),
    SYBASE(6,"SyBase"),
    DB2(7,"DB2"),
    MARIADB(8,"MariaDB"),
    MONGODB(9,"MongoDB"),
    COUCHBASE(10,"Couchbase"),
    AMAZON(11,"Amazon"),
    DYNAMODB(12,"DynamoDB"),
    COUCHDB(13,"CouchDB"),
    MARKLOGIC(14,"MarkLogic"),
    NEO4J(15,"Neo4j"),
    ORIENTDB(16,"OrientDB"),
    TITAN(17,"Titan"),
    VIRTUOSO(18,"Virtuoso"),
    ARANGODB(19,"ArangoDB "),
    HANGAO(20,"瀚高"),
    DAMENG(21,"达梦"),
    SHENTONG(22,"神通"),
    JINCHANG(23,"人大金仓"),
    OTHER(24,"其他：请在备注中填写,如需填写多个,请以逗号分隔"),
    NONE(-1,"无");

    private Integer code;
    private String name;

    DatabaseType() {
    }
    private static Map<String, DatabaseType> databaseTypeMap=new HashMap<>();
    static {
        for (DatabaseType databaseType : DatabaseType.values()) {
            databaseTypeMap.put(databaseType.getName(),databaseType);
        }
    }
    DatabaseType(Integer code, String name) {
        this.code = code;
        this.name = name;
    }
    public static DatabaseType getByName(String name) {
        DatabaseType databaseType = databaseTypeMap.get(name);
        if (databaseType == null) {
            return OTHER;
        }
        return databaseType;
    }
}
