package com.zjty.inspect.enums;

import com.zjty.inspect.entity.FontTechnologyEnum;
import com.zjty.inspect.entity.OpgaEnum;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * <h4>Description : inspect</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2020-03-05 17:53
 */
@Getter
public enum MiddlewareEnum {
     IIS(1,"IIS"),
    JONAS(1,"JOnAS"),
    HADOOP(1,"Hadoop"),
    KAFKA(1,"Kafka"),
    SPARK(1,"Spark"),
    LVS(1,"LVS"),
    LHA(1,"LHA"),
    GERONIMO(1,"Geronimo"),
    JINDIE(1,"金蝶"),
    DONGFANGTONG(1,"东方通"),
    OTHER(1,"其他：请在备注中填写,如需填写多个,请以逗号分隔"),
    TOMCAT(1,"Tomcat"),
    JBOSS(1,"JBOSS"),
    NGNIX(1,"Ngnix"),
    WEBSPHERE(1,"Websphere"),
    WEBLOGIC(1,"Weblogic"),
    NONE(1,"无");
     private Integer code;
     private String name;
    private static Map<String, MiddlewareEnum> middlewareEnumMap=new HashMap<>();
    static {
        for (MiddlewareEnum middlewareEnum : MiddlewareEnum.values()) {
            middlewareEnumMap.put(middlewareEnum.getName(),middlewareEnum);
        }
    }
    MiddlewareEnum() {
    }

    MiddlewareEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }
    public static MiddlewareEnum getByName(String name){
        MiddlewareEnum middlewareEnum = middlewareEnumMap.get(name);
        if(middlewareEnum == null){
            return null;
        }
        return middlewareEnum;
    }
}
