package com.zjty.inspect.entity;

import com.zjty.inspect.enums.ApplicationType;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <h4>Description : 应用系统改造替换表单</h4>
 *
 * @author : czq
 * @Date : 2020-03-05 16:43
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Reform {
    /*
    基础
     */

    /**
     * admin 是否是管理员
     */
    private Integer admin = -1;

    private Integer authority;

    /**
     * username
     */
    private String username;

    /**
     *评估类型1：快速   2：详细
     */
    private Integer assessmentType;
    /*
    快速评估部分
     */

    /**
     * 替换方式  int（1：改造 2：适配）
     */
    private Integer mode = -1;

    /**
     * 系统名称
     */
    private String projectName;


    /**
     * 代码地址
     */
    private String codeUrl;

    /**
     * 文件名称
     */
    private String codeName;

    /**
     * git地址
     */
    private String gitUrl;

    /**
     * 模块数
     */
    private Integer moduleNum = -1;

    /**
     * 原开发费用
     */
    private Integer cost = -1;


    /**
     * 开发单位是否在本地int 1:是 2：否
     */
    private Integer address = -1;

    /**
     * 是否为涉密信息系统 int 1:是 2：否
     */
    private Integer secret = -1;

    /**
     * 容灾能力 int 1:是 2：否
     */
    private Integer disasterTolerance = -1;

    /**
     * 安全能力
     * 1：无
     * 2：弱
     * 3：强
     */
    private Integer safe = -1;

    /**
     * 架构
     */
    private Integer framework = -1;

    /**
     * 该应用类型
     */
    private List<Integer> applicationType = new ArrayList<>();

    /**
     * 运行时间
     */
    private Integer time = -1;

    /**
     * 数据库表数量
     */
    private Integer tableNum = -1;

    /**
     * 数据库数据量
     */
    private Integer databaseNum = -1;
    /*
    详细填写
     */

    /**
     * 系统部署架构
     */
    private SystemStructure systemStructure = new SystemStructure();

    /**
     * 前端浏览器相关
     */
    private Browser browser = new Browser();

    /**
     * 中间件/API
     */
    private Middleware middleware = new Middleware();

    /**
     * 数据库相关
     */
    private Database database = new Database();

    /**
     * 迁移策略 1：休息日 2：晚间切换 3:短暂停止
     */
    private Integer strategy = -1;
    /**
     * 额外申请
     */
    private Apply apply = new Apply();

}
