package com.zjty.inspect.dao;


import com.zjty.inspect.entity.Rule;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import java.util.List;

public interface RuleDao extends JpaRepository<Rule,String>,JpaSpecificationExecutor<Rule> {
    /**
     * 根据目标关键字查询规则
     * @param target 目标关键字
     * @return
     */
    Rule findAllByTargetEquals(String target);

    /**
     * 根据目标关键字查询规则
     * @param target 目标关键字
     * @param techId 关键技术id
     * @return
     */
    Rule findAllByTargetEqualsAndTechnologyIdEquals(String target,String techId);

    List<Rule> findAllByTargetLike(String target);
    List<Rule> findAllByTarget(String target);

    Rule findByTarget(String target);

    List<Rule> findByTargetAndSuffixEqualsAndTechnologyIdEquals(String target,String suffix,String technologyId);

    /**
     * 根据技术id查询规则
     * @param ids 技术id
     * @return
     */
    List<Rule> findAllByTechnologyIdIn(List<String> ids);
    List<Rule> findAllByTechnologyId(String id);

    List<Rule> findAllByTechnologyIdEqualsAndTargetEquals(String techId,String target);
}
