package com.zjty.inspect.controller;

import com.zjty.inspect.entity.Technology;
import com.zjty.inspect.entity.TechnologyQo;
import com.zjty.inspect.service.TechnologyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * 适配技术
 * @author Mcj
 * @date 2020-02-29 16:10
 */

@RequestMapping("/technology")
@RestController
@Api(value = "适配技术页面管理接口",description = "适配技术页面管理接口,提供页面的增、删、改、查")
public class TechnologyController {

    @Autowired
    private TechnologyService technologyService;

    /**
     * 获取所有关键技术
     * @return List
     */
    @GetMapping
    @ApiOperation("获取所有关键技术")
    public ResponseEntity getTechnologies(){
        return ResponseEntity.ok(technologyService.findAllTechnology());
    }
    @GetMapping("/names")
    @ApiOperation("获取所有关键技术name")
    public ResponseEntity getTechnologiesName(){
        return ResponseEntity.ok(technologyService.findAllTechnologyNames());
    }

    /**
     * 获取所有关键技术
     * @return List
     */
    @GetMapping(value = "/{name}")
    @ApiOperation("根据name获取所有关键技术")
    public ResponseEntity getTechnologies(@PathVariable String name){
        return ResponseEntity.ok(technologyService.findAllTechnology(name));
    }
    /**
     * 添加关键技术
     * @return List
     */
    @PostMapping
    @ApiOperation("添加关键技术")
    public ResponseEntity addTechnologies(@RequestBody TechnologyQo technologyQo){
        technologyService.addAdvice(technologyQo);
        return ResponseEntity.ok(200);
    }
    @PostMapping("/add")
    @ApiOperation("新添加关键技术")
    public ResponseEntity addTechnologies(@RequestBody Technology technology){
        technologyService.add(technology);
        return ResponseEntity.ok(200);

    }
    @PostMapping(value = "/{id}")
    @ApiOperation("修改关键技术")
    public ResponseEntity update(@RequestBody Technology technology,@PathVariable String id){
        technology.setId(id);
        technologyService.update(technology);
        return ResponseEntity.ok(200);
    }
}
