package com.zjty.inspect.dao;

import com.zjty.inspect.entity.Technology;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

public interface TechnologyDao extends JpaRepository<Technology,String> {

    /**
     * 根据名称查询适配技术
     * @param name 适配技术名称
     * @return Technology
     */
    Technology findAllByTechnologyNameEquals(String name);

    List<Technology> findAllByTechnologyNameLike(String name);

    /**
     * 根据id查询
     * @param ids ids
     * @return
     */
    List<Technology> findAllByIdIn(List<String> ids);


    @Query("select technologyName from Technology ")
    List<String> getTechnologyNames();
}
