package com.zjty.inspect.controller;

import com.zjty.inspect.entity.InspectParameter;
import com.zjty.inspect.entity.ReportVo;
import com.zjty.inspect.entity.Technology;
import com.zjty.inspect.entity.Warn;
import com.zjty.inspect.service.InspectService;
import com.zjty.inspect.utils.*;
import freemarker.template.TemplateException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.io.FileUtils;
import org.apache.tomcat.util.http.fileupload.disk.DiskFileItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import java.io.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 评估接口
 * @author mcj
 */
@RestController
@RequestMapping("/inspect")
@Api(value = "评估接口管理接口",description = "评估管理接口,提供页面的增、删、改、查")
public class InspectController {
    @Autowired
    private InspectService inspectService;


    /**
     * 上传代码进行评估
     * @param years      系统开发时间
     * @param systemFund    系统开发费用
     * @param modules   模块数
     * @param valid     预算数据是否可用
     * @param framework 架构
     * @param safety    安全能力
     * @param disaster  容灾能力
     * @param data  数据量
     * @param admin 是否管理员
     * @param multfile  文件
     * @return
     * @throws IOException
     */
    @PostMapping("/path")
    @ApiOperation("上传代码进行评估")
    public ResponseEntity inspect(Integer years,Integer systemFund,Integer modules
            ,String valid,Double framework,Double safety,Double disaster,Integer data
            ,Integer admin,String projectName,String fileName, MultipartFile multfile) throws IOException {

        File file = FileUtil.saveToLocal(multfile);
        InspectParameter inspectParameter = new InspectParameter();
        inspectParameter.setSourceAddress(file.getPath());
        inspectParameter.setSystemFund(systemFund);
        inspectParameter.setAdmin(admin);
        inspectParameter.setModules(modules);
        inspectParameter.setSafety(safety);
        inspectParameter.setValid(valid);
        inspectParameter.setYears(years);
        inspectParameter.setDisaster(disaster);
        inspectParameter.setData(data);
        inspectParameter.setFramework(framework);
        inspectParameter.setPath(file.getCanonicalPath());
        inspectParameter.setId(UUIDUtil.getUUID());
        ReportVo reportVo = new ReportVo();


        reportVo.setId(TimeUtil.getNowDate());
        reportVo.setUploadType("文件上传");
        reportVo.setFileName(fileName);
        reportVo.setProjectName(projectName);
        reportVo.setSourceAddress(file.getCanonicalPath());

        ReportVo inspect = inspectService.inspect(reportVo,inspectParameter);
//        Map map=new HashMap();
//        map.put("inspect",inspect);
//        map.put("time",TimeUtil.getTime());
//        HashMap<String, List<Warn>> warnMap = inspect.getWarnDetails();
//        List<Technology> technologies = inspect.getTechnologies();
//        map.put("warnMap",warnMap);
//        map.put("technologies",technologies);
//        try {
//            String template = FreemarkerUtils.getTemplate("pg.ftl", map);
//            String s = inspectService.generateHtml(template, map);
//            System.out.println("内容"+s);
//        } catch (TemplateException e) {
//            e.printStackTrace();
//        }

        return ResponseEntity.ok(inspect);
    }

    /**
     * git下载代码进行评估
     * @param inspectParameter 封装
     * @return
     */
    @PostMapping("/git")
    @ApiOperation("git下载代码进行评估")
    public ResponseEntity inspect1(@RequestBody InspectParameter inspectParameter){
        String path = GitLabUtil.downLoadProject(inspectParameter.getGitAddress(),inspectParameter.getGitName());
        inspectParameter.setId(UUIDUtil.getUUID());
        inspectParameter.setPath(path);
        ReportVo reportVo = new ReportVo();
        reportVo.setUploadType("git下载");
        reportVo.setSourceAddress(path);
        reportVo.setGitAddress(inspectParameter.getGitAddress());
        inspectService.inspect(reportVo,inspectParameter);
        return ResponseEntity.ok(200);
    }

    @PostMapping("/frontend")
    @ApiOperation("git下载代码进行评估")
    public ResponseEntity inspect(MultipartFile file) throws IOException {

        return ResponseEntity.ok(200);
    }

}
