package com.zjty.inspect.service.impl;

import com.zjty.inspect.entity.InspectParameter;
import com.zjty.inspect.entity.Report;
import com.zjty.inspect.entity.ReportVo;
import com.zjty.inspect.service.InspectService;
import com.zjty.inspect.utils.Inspector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.Map;

/**
 * 解析
 * @author mcj
 */
@Service
public class InspectServiceImpl implements InspectService {

    @Autowired
    Inspector inspector;


    @Transactional
    @Override
    public ReportVo inspect(ReportVo reportVo,InspectParameter inspectParameter) {
        Map<String, Report.Language> suffixLanguageMapping = new HashMap<>();
        suffixLanguageMapping.put("java", Report.Language.JAVA);
        suffixLanguageMapping.put("vue", Report.Language.VUE);
        suffixLanguageMapping.put("cpp", Report.Language.CPP);
        suffixLanguageMapping.put("py", Report.Language.PYTHON);
        suffixLanguageMapping.put("jsp", Report.Language.JSP);
        suffixLanguageMapping.put("go", Report.Language.GO);
        inspector.setInspectParameter(inspectParameter);
        inspector.setReport(reportVo);
        inspector.setSuffixLanguageMapping(suffixLanguageMapping);
        inspector.setPath(inspectParameter.getPath());
        ReportVo report = inspector.inspect();
        return report;
    }
}
