package com.zjty.inspect.controller;

import com.zjty.inspect.entity.InspectParameter;
import com.zjty.inspect.service.ParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author Mcj
 * @date 2020-03-03 11:00
 */
@RestController
@RequestMapping("/param")
public class ParamController {

    @Autowired
    private ParameterService parameterService;

    @GetMapping
    public ResponseEntity getParam(String id){
        return ResponseEntity.ok(parameterService.getParameterById(id));
    }

    @PostMapping
    public ResponseEntity saveParam(@RequestBody InspectParameter inspectParameter){
        parameterService.saveParameter(inspectParameter);
        return ResponseEntity.ok(200);
    }

}
