package com.zjty.inspect.utils;

import com.zjty.inspect.entity.*;
import com.zjty.inspect.enums.CompatibleBrowser;
import com.zjty.inspect.enums.DatabaseType;
import com.zjty.inspect.enums.MiddlewareEnum;
import com.zjty.inspect.enums.OperateSystem;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author Mcj
 * @date 2019-07-17 16:52
 */

public class ExcelUtil {

    private static String xlsx = "xlsx";
    private static String xls = "xls";

    public static Reform parseExcel(MultipartFile f1) {
        try {
            InputStream fileInputStream = f1.getInputStream();
            String[] split = Objects.requireNonNull(f1.getOriginalFilename()).split("\\.");
            if (xlsx.equals(split[1])) {
                XSSFWorkbook xwb = new XSSFWorkbook(fileInputStream);
                //3、得到Excel工作表对象
                XSSFSheet sheetAt = xwb.getSheetAt(0);
                Reform reform = getReform(sheetAt);

                return reform;

            } else if (xls.equals(split[1])) {
                HSSFWorkbook xwb = new HSSFWorkbook(fileInputStream);
                //3、得到Excel工作表对象
                HSSFSheet sheetAt = xwb.getSheetAt(0);
                Reform reform = getReform(sheetAt);
                return reform;
            }

        } catch (IOException e) {
            e.printStackTrace();
        }
        return new Reform();
    }

    private static String getExcelCell(int rowNum, int cellNum, Sheet sheetAt) {
        Row row = sheetAt.getRow(rowNum);
        Cell cell = row.getCell(cellNum);
        return cell.toString();
    }

    private static Reform getReform(Sheet sheetAt) {
        Reform reform = new Reform();
        //单位名称
        String unitName = getExcelCell(2, 2, sheetAt);
        reform.setUnitName(unitName);
        //系统名称
        String projectName = getExcelCell(3, 2, sheetAt);
        reform.setProjectName(projectName);
        String cost = getExcelCell(4, 2, sheetAt);
        if (!cost.equals("")) {
            reform.setCost(Integer.valueOf(cost));
        }
        String time = getExcelCell(6, 2, sheetAt);
        if (!"".equals(time)) {
            if ("10年以上".equals(time)) {
                reform.setTime(11);
            } else {
                String year = time.replaceAll("年", "");
                Integer newYear = Integer.valueOf(year);
                reform.setTime(newYear);
            }
        }
        String address = getExcelCell(7, 2, sheetAt);
        if ("是".equals(address)) {
            reform.setAddress(1);
        } else {
            reform.setAddress(2);
        }

        String secret = getExcelCell(8, 2, sheetAt);
        if ("是".equals(secret)) {
            reform.setSecret(1);
        } else {
            reform.setSecret(2);
        }

        String construction = getExcelCell(10, 2, sheetAt);
        if ("B/S".equals(construction) || "C/S".equals(construction)) {
            reform.setFramework(2);
        } else if ("单机运行".equals(construction)) {
            reform.setAddress(0);
        } else if ("分布式".equals(construction)) {
            reform.setFramework(4);
        }

        String disaster = getExcelCell(11, 2, sheetAt);
        if ("是".equals(disaster)) {
            reform.setDisasterTolerance(4);
        } else {
            reform.setDisasterTolerance(0);
        }
        String type = getExcelCell(12, 2, sheetAt);
        ArrayList<Integer> applicationType = new ArrayList<>();
        if ("办公OA应用类".equals(type)) {
            applicationType.add(1);
        } else if ("门户、信息发布、综合入口服务类".equals(type)) {
            applicationType.add(2);
        } else if ("申报、填报、审批等公共行政服务类".equals(type)) {
            applicationType.add(4);
        } else if ("数据收集、分析、态势感知等大数据应用类".equals(type)) {
            applicationType.add(5);
        } else if ("地图、定位等GIS服务类".equals(type)) {
            applicationType.add(6);
        } else if ("视频、图形等流媒体应用类".equals(type)) {
            applicationType.add(7);
        } else if ("3D、模型等视觉建模应用类".equals(type)) {
            applicationType.add(8);
        }
        reform.setApplicationType(applicationType);

        String module = getExcelCell(13, 2, sheetAt);
        if (!"".equals(module)) {
            reform.setModuleNum(Integer.valueOf(module));
        }
        String mode = getExcelCell(15, 2, sheetAt);
        if ("终端适配".equals(mode)) {
            reform.setMode(2);
        } else {
            reform.setMode(1);
        }
        DevelopLanguageSystem developLanguageSystem = new DevelopLanguageSystem();
        List<DevFramework> devFrameworks = new ArrayList<>();
        for (int i = 17; i < 20; i++) {
            String framework = getExcelCell(i, 2, sheetAt);
            String version = getExcelCell(i, 3, sheetAt);
            String remark = getExcelCell(i, 4, sheetAt);
            DevFramework devFramework = new DevFramework();
            devFramework.setFrameWork(FrameWorkEnum.valueOf(framework));
            devFramework.setVersion(version);
            devFramework.setDes(remark);
            devFrameworks.add(devFramework);
        }
        developLanguageSystem.setDevFrameworks(devFrameworks);

        for (int i = 20; i < 25; i++) {


        }
        /**
         * 中间件/API
         */
        Middleware middleware = new Middleware();
        List<MiddlewareEnum> middlewareEnums = new ArrayList<>();
        for (int i = 40; i < 45; i++) {
            String middleware1 = getExcelCell(i, 2, sheetAt);
            if (middleware1.equals("Tomcat")) {
                middlewareEnums.add(MiddlewareEnum.TOMCAT);
            } else if (middleware1.equals("JBOSS")) {
                middlewareEnums.add(MiddlewareEnum.JBOSS);
            } else if (middleware1.equals("Ngnix")) {
                middlewareEnums.add(MiddlewareEnum.NGNIX);
            } else if (middleware1.equals("Weblogic")) {
                middlewareEnums.add(MiddlewareEnum.WEBLOGIC);
            } else if (middleware1.equals("Websphere")) {
                middlewareEnums.add(MiddlewareEnum.WEBSPHERE);
            } else {
                middlewareEnums.add(MiddlewareEnum.NONE);
            }
        }
        middleware.setMiddlewareEnums(middlewareEnums);
        reform.setMiddleware(middleware);
        //数据库相关
        Database database1 = new Database();
        ArrayList<DatabaseType> databaseTypes = new ArrayList<>();
        for (int i = 68; i < 71; i++) {
            String database = getExcelCell(i, 2, sheetAt);
            if ("MySQL".equals(database)) {
                databaseTypes.add(DatabaseType.MYSQL);
            } else if ("SQL SERVER".equals(database)) {
                databaseTypes.add(DatabaseType.SQLSERVER);
            } else if ("Oracle".equals(database)) {
                databaseTypes.add(DatabaseType.ORACLE);
            } else if ("DB2".equals(database)) {
                databaseTypes.add(DatabaseType.DB2);
            } else if ("SyBase".equals(database)) {
                databaseTypes.add(DatabaseType.SYBASE);
            } else {
                databaseTypes.add(DatabaseType.NONE);
            }
        }
        database1.setDatabaseType(databaseTypes);

        String tableNum = getExcelCell(71, 2, sheetAt);
        if("".equals(tableNum)){
            reform.setTableNum(0);
        }else{
            reform.setTableNum(Integer.valueOf(tableNum));
        }

        String sp = getExcelCell(75, 2, sheetAt);
        if ("是".equals(sp)) {
            database1.setSeparate(1);
        } else {
            database1.setSeparate(2);
        }
        String dblink = getExcelCell(76, 2, sheetAt);
        if ("是".equals(dblink)) {
            database1.setDbLink(1);
        } else {
            database1.setDbLink(2);
        }
        String view = getExcelCell(77, 2, sheetAt);
        if ("是".equals(view)) {
            database1.setView(1);
        } else {
            database1.setView(2);
        }
        String storage = getExcelCell(78, 2, sheetAt);
        if ("是".equals(storage)) {
            database1.setStorage(1);
        } else {
            database1.setStorage(2);
        }
        String function = getExcelCell(79, 2, sheetAt);
        if ("是".equals(function)) {
            database1.setFunction(1);
        } else {
            database1.setFunction(2);
        }
        String timeTask = getExcelCell(80, 2, sheetAt);
        if ("是".equals(timeTask)) {
            database1.setTimeTask(1);
        } else {
            database1.setTimeTask(2);
        }
        String sequence = getExcelCell(81, 2, sheetAt);
        if ("是".equals(sequence)) {
            database1.setSequence(1);
        } else {
            database1.setSequence(2);
        }
        String trigger = getExcelCell(82, 2, sheetAt);
        if ("是".equals(trigger)) {
            database1.setTrigger(1);
        } else {
            database1.setTrigger(2);
        }
        String disasterTolerance = getExcelCell(83, 2, sheetAt);
        if ("是".equals(disasterTolerance)) {
            database1.setDisasterTolerance(2);
        } else {
            database1.setDisasterTolerance(1);
        }
        String safe = getExcelCell(84, 2, sheetAt);
        if ("是".equals(safe)) {
            database1.setSafe(1);
        } else {
            database1.setSafe(2);
        }
        String performance = getExcelCell(85, 2, sheetAt);
        if (!"无".equals(safe)) {
            database1.setPerformance(1);
        }
        reform.setDatabase(database1);

        Browser browser = new Browser();
        List<CompatibleBrowser> compatibleBrowsers = new ArrayList<>();
        for (int i = 87; i < 92; i++) {
            String brows = getExcelCell(i, 2, sheetAt);
            if ("IE（Trident内核）".equals(brows)) {
                compatibleBrowsers.add(CompatibleBrowser.IETRIDENT);
            } else if ("Chrome（Webkit/Blink内核）".equals(brows) || "Chrome（Chromium内核）".equals(brows)) {
                compatibleBrowsers.add(CompatibleBrowser.CHROMEWEBKIT);
            } else if ("Firefox（Gecko内核）".equals(brows)) {
                compatibleBrowsers.add(CompatibleBrowser.FIREFOX);
            } else if ("Opera（Blink内核）".equals(brows)) {
                compatibleBrowsers.add(CompatibleBrowser.OPERA);
            } else {
                compatibleBrowsers.add(CompatibleBrowser.NONE);
            }
        }
        browser.setCompatibleBrowsers(compatibleBrowsers);
        for (int i = 92; i < 101; i++) {
            String plugin = getExcelCell(i, 2, sheetAt);
            if ("在线文本编辑类：请在备注中填写插件名和版本".equals(plugin)) {
                browser.setDocument(1);
            } else if ("打印调用".equals(plugin) || "扫描调用".equals(plugin)) {
                browser.setPeripheral(1);
            } else if ("在线3D建模、渲染、展现：请在备注中填写插件名和版本".equals(plugin)) {
                browser.setThreeD(1);
            } else if ("在线视频播放类：请在备注中填写插件名和版本".equals(plugin)) {
                browser.setMedia(1);
            } else {
                browser.setOtherDemand(1);
            }
        }

        SystemStructure systemStructure = new SystemStructure();
        Details ecsdetails = new Details();
        String ecs = getExcelCell(107, 2, sheetAt);
        if ("本地".equals(ecs)) {
            ecsdetails.setDeploy(1);
        } else if ("政务云".equals(ecs)) {
            ecsdetails.setDeploy(2);
        }
        String ecssys = getExcelCell(107, 4, sheetAt);
        if ("CentOS系列".equals(ecssys)) {
            ecsdetails.setOperateSystem(OperateSystem.CENTEROSREALES);
        } else if ("WindowsServer（2008-2016）".equals(ecssys) || "WindowsServer（2016-2020）".equals(ecssys)) {
            ecsdetails.setOperateSystem(OperateSystem.WINSERVER2012);
        } else if ("Ubuntu系列".equals(ecssys)) {
            ecsdetails.setOperateSystem(OperateSystem.UBUNTU);
        } else if ("Redhat/OracleLinux系列".equals(ecssys)) {
            ecsdetails.setOperateSystem(OperateSystem.REDHATREALES);
        } else {
            ecsdetails.setOperateSystem(OperateSystem.NONE);
        }
        systemStructure.setApplication(ecsdetails);

        Details rdsdetails = new Details();
        String rds = getExcelCell(108, 2, sheetAt);

        if ("本地".equals(rds)) {
            rdsdetails.setDeploy(1);
        } else if ("政务云".equals(rds)) {
            rdsdetails.setDeploy(2);
        }
        String rdssys = getExcelCell(108, 4, sheetAt);
        if ("CentOS系列".equals(rdssys)) {
            rdsdetails.setOperateSystem(OperateSystem.CENTEROSREALES);
        } else if ("WindowsServer（2008-2016）".equals(rdssys) || "WindowsServer（2016-2020）".equals(rdssys)) {
            rdsdetails.setOperateSystem(OperateSystem.WINSERVER2012);
        } else if ("Ubuntu系列".equals(rdssys)) {
            rdsdetails.setOperateSystem(OperateSystem.UBUNTU);
        } else if ("Redhat/OracleLinux系列".equals(rdssys)) {
            rdsdetails.setOperateSystem(OperateSystem.REDHATREALES);
        } else {
            rdsdetails.setOperateSystem(OperateSystem.NONE);
        }
        systemStructure.setDatabase(rdsdetails);


        Details nasdetails = new Details();
        String nas = getExcelCell(109, 2, sheetAt);

        if ("本地".equals(nas)) {
            nasdetails.setDeploy(1);
        } else if ("政务云".equals(nas)) {
            nasdetails.setDeploy(2);
        }
        String nassys = getExcelCell(109, 4, sheetAt);
        if ("CentOS系列".equals(nassys)) {
            nasdetails.setOperateSystem(OperateSystem.CENTEROSREALES);
        } else if ("WindowsServer（2008-2016）".equals(nassys) || "WindowsServer（2016-2020）".equals(nassys)) {
            nasdetails.setOperateSystem(OperateSystem.WINSERVER2012);
        } else if ("Ubuntu系列".equals(nassys)) {
            nasdetails.setOperateSystem(OperateSystem.UBUNTU);
        } else if ("Redhat/OracleLinux系列".equals(nassys)) {
            nasdetails.setOperateSystem(OperateSystem.REDHATREALES);
        } else {
            nasdetails.setOperateSystem(OperateSystem.NONE);
        }
        systemStructure.setStorage(nasdetails);
        Details slbdetails = new Details();

        String slb = getExcelCell(110, 2, sheetAt);

        if ("本地".equals(slb)) {
            slbdetails.setDeploy(1);
        } else if ("政务云".equals(slb)) {
            slbdetails.setDeploy(2);
        }
        String slbsys = getExcelCell(110, 4, sheetAt);
        if ("CentOS系列".equals(slbsys)) {
            slbdetails.setOperateSystem(OperateSystem.CENTEROSREALES);
        } else if ("WindowsServer（2008-2016）".equals(slbsys) || "WindowsServer（2016-2020）".equals(slbsys)) {
            slbdetails.setOperateSystem(OperateSystem.WINSERVER2012);
        } else if ("Ubuntu系列".equals(slbsys)) {
            slbdetails.setOperateSystem(OperateSystem.UBUNTU);
        } else if ("Redhat/OracleLinux系列".equals(slbsys)) {
            slbdetails.setOperateSystem(OperateSystem.REDHATREALES);
        } else {
            slbdetails.setOperateSystem(OperateSystem.NONE);
        }
        systemStructure.setSlb(slbdetails);

        reform.setSystemStructure(systemStructure);

        return reform;
    }


    public static void main(String[] args) {
        MultipartFile f = null;
        ExcelUtil.parseExcel(f);

    }

}

