package com.zjty.inspect.utils;

import com.zjty.inspect.dao.CoefficientModelDao;
import com.zjty.inspect.dao.ConfigParamDao;
import com.zjty.inspect.entity.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 获取预算
 * @author Mcj
 * @date 2020-02-26 15:14
 */

@Component
public class BudgetUitl {

    @Autowired
    private ConfigParamDao configParamDao;

    @Autowired
    private CoefficientModelDao coefficientModelDao;

    /**
     * 获取预算数据
     * @param fund 技术费用
     * @param report
     * @param inspectParameter  计算所需数据
     * @return
     */
    public BudgetVo getBudget(Integer fund, ReportVo report, InspectParameter inspectParameter){

        BudgetVo budgetVo = new BudgetVo();

        // TODO: 2020-03-05 查询年复利率,查询修改，适配和重构占比
        List<Config> all = configParamDao.findAll();
        HashMap<Integer, String> doubleHashMap = new HashMap<>();
        for (Config config : all) {
            if(!doubleHashMap.containsKey(config.getType())){
                doubleHashMap.put(config.getType(),config.getValue());
            }
        }
        int scale;
        Integer systemFund = inspectParameter.getSystemFund();
        if(systemFund==0){
            double v = inspectParameter.getModules() * 7.5;
            systemFund= (int) v;
        }
        if(systemFund<30){
            scale=1;
        }else if(systemFund<200){
            scale=2;
        }else{
            scale=3;
        }
        inspectParameter.setMoneyRate(Double.valueOf(doubleHashMap.get(1)));
        Double moneyRate = inspectParameter.getMoneyRate();
        int years = inspectParameter.getYears();
        double pow = Math.pow(moneyRate, years);

        //带修正系数资金
        ArrayList<String> strings = new ArrayList<>();
        strings.add("安全能力");
        strings.add("容灾能力");
        strings.add("架构");
        strings.add("数据量");
        strings.add("模块数");
        strings.add("数据库表");
        strings.add("代码量");
        strings.add("内容");
        double coefficient = 1;
        List<CoefficientModel> nameIn = coefficientModelDao.findAllByNameIn(strings);
        List<CoefficientModel> collect = nameIn.stream().filter(a -> a.getScale() == scale).collect(Collectors.toList());
        for (CoefficientModel model : collect) {
            CoefficientModelVo coefficientModelVo = new CoefficientModelVo();
            coefficientModelVo.setName(model.getName());
            if("架构".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getFramework());
                coefficientModelVo.setValue(value);
                coefficient*=value;
            }else if("容灾能力".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getDisaster());
                coefficientModelVo.setValue(value);
                coefficient*=value;
            }
            else if("安全能力".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getSafety());
                coefficientModelVo.setValue(value);
                coefficient*=value;
            }
            else if("数据量".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getData());
                coefficientModelVo.setValue(value);
                coefficient*=value;
            }
            else if("模块数".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getModules());
                coefficientModelVo.setValue(value);
                coefficient*=value;
            }
            else if("数据库表".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getTables());
                coefficientModelVo.setValue(value);
                coefficient *=value;
            }
            else if("代码量".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getCodeSize());
                coefficientModelVo.setValue(value);
                coefficient*=value;
            }else if("内容".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getContent());
                coefficientModelVo.setValue(value);
                coefficient*=value;
            }
            budgetVo.getCoefficientModelVos().add(coefficientModelVo);
        }

        if(inspectParameter.getRecastMethod()==1){
            //用户需要适配
            double refactorProportion = Double.valueOf(doubleHashMap.get(4));
            inspectParameter.setProportion(refactorProportion);
            Budget codeRefactor = new Budget();
            codeRefactor.setBudgetName("代码修改预算");
            double fundNotRepair = inspectParameter.getProportion() * pow * systemFund + fund;
            double fundRepair=fundNotRepair*coefficient;
            if(fundNotRepair<fundRepair){
                codeRefactor.setFund(fundNotRepair +"--"+fundRepair);
            }else if(fundNotRepair>fundRepair){
                codeRefactor.setFund(fundRepair +"--"+fundNotRepair);
            }else{
                codeRefactor.setFund(fundRepair +"--"+fundNotRepair);
            }
            codeRefactor.setFundDetail("普通业务开发费用:"+fundNotRepair);
            codeRefactor.setFundDetail("普通业务开发费用(修正):"+fundRepair);
            codeRefactor.setFundDetail("关键适配技术成本:"+fund);
            budgetVo.getBudget().add(codeRefactor);
            if(report.getRecastMethod()==1){
                double refactorProportion1 = Double.valueOf(doubleHashMap.get(2));
                inspectParameter.setProportion(refactorProportion1);
                Budget codeRefactor1 = new Budget();
                codeRefactor1.setBudgetName("代码重构预算");
                double fundNotRepair1 = inspectParameter.getProportion() * pow * systemFund + fund;
                double fundRepair1=fundNotRepair1*coefficient;
                if(fundNotRepair1<fundRepair1){
                    codeRefactor1.setFund(fundNotRepair1 +"--"+fundRepair1);
                }else if(fundNotRepair1>fundRepair1){
                    codeRefactor1.setFund(fundRepair1 +"--"+fundNotRepair1);
                }else{
                    codeRefactor1.setFund(fundRepair1 +"--"+fundNotRepair1);
                }
                codeRefactor1.setFundDetail("普通业务开发费用:"+fundNotRepair1);
                codeRefactor1.setFundDetail("普通业务开发费用(修正):"+fundRepair1);
                codeRefactor1.setFundDetail("关键适配技术成本:"+fund);
                budgetVo.getBudget().add(codeRefactor1);
            }
        }else{
            double refactorProportion = Double.valueOf(doubleHashMap.get(3));
            inspectParameter.setProportion(refactorProportion);
            Budget codeRefactor1 = new Budget();
            codeRefactor1.setBudgetName("代码修改预算");
            double fundNotRepair1 = inspectParameter.getProportion() * pow * systemFund + fund;
            double fundRepair1=fundNotRepair1*coefficient;
            if(fundNotRepair1<fundRepair1){
                codeRefactor1.setFund(fundNotRepair1 +"--"+fundRepair1);
            }else if(fundNotRepair1>fundRepair1){
                codeRefactor1.setFund(fundRepair1 +"--"+fundNotRepair1);
            }else{
                codeRefactor1.setFund(fundRepair1 +"--"+fundNotRepair1);
            }
            codeRefactor1.setFundDetail("普通业务开发费用:"+fundNotRepair1);
            codeRefactor1.setFundDetail("普通业务开发费用(修正):"+fundRepair1);
            codeRefactor1.setFundDetail("关键适配技术成本:"+fund);
            budgetVo.getBudget().add(codeRefactor1);
        }

        return budgetVo;
    }
}
