package com.zjty.inspect.controller;

import com.zjty.inspect.aop.AuthAnnotation;
import com.zjty.inspect.entity.Config;
import com.zjty.inspect.entity.RuleQo;
import com.zjty.inspect.service.ConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@RestController
@RequestMapping("/config")
@Api(value = "参数配置接口管理接口",description = "参数配置管理接口,提供页面的增、删、改、查")
public class ConfigController {
    @Autowired
    private ConfigService configService;

    /**
     * 查询所有参数配置
     * @return 参数配置
     */
    @ApiOperation("查询所有参数配置")
    @GetMapping
    public ResponseEntity getConfigs(){
        return ResponseEntity.ok(configService.findAll());
    }

    /**
     * 根据id修改参数
     * @param
     * @param
     * @return
     */
    @PostMapping("/updates")
    @ApiOperation("根据id修改参数,需要传id和value")
    @AuthAnnotation(code = {"1300"})
    public ResponseEntity update(@RequestBody List<Config> configs){
        configService.updateConfig(configs);
        return ResponseEntity.ok(200);
    }
}
