package com.zjty.inspect.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.Id;

/**
 * 传入参数表
 * @author Mcj
 * @date 2020-02-12 12:35
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
public class InspectParameter {

    @Id
    private String id;

    /**
     * 用户名
     */
    private String username;
    /**
     *  重构占比
     */
    private Double proportion;

    /**
     * 年利率
     */
    private Double moneyRate;

    /**
     * 软件开发时间
     */
    private Integer years;

    /**
     * 原系统费用
     */
    private Integer systemFund;

    /**
     * 模块数
     */
    private Integer modules;

    /**
     * 数据量
     */
    private Integer data;

    /**
     * 代码量
     */
    private Integer codeSize;

    /**
     * 内容
     */
    private Integer content;
    /**
     * 架构
     */
    private Integer framework;

    /**
     * 数据库表数量
     */
    private Integer tables;

    /**
     * 安全能力
     * 0：无
     * 2：弱
     * 4：强
     */
    private Integer safety;

    /**
     * 容灾
     * 0：无0，有+0.05
     * 2：有0，无-0.05
     * 4：有0，无-0.1
     */
    private Integer disaster;

    /**
     * null:无效
     */
    private String valid;

    /**
     * 评估报告地址
     */
    private String reportAddress;

    /**
     * git上传地址
     */
    private String gitAddress;

    /**
     * 项目名称
     */
    private String gitName;

    /**
     * 源代码存储地址
     */
    private String sourceAddress;

    /**
     * 是否管理员
     * 1:是
     * 0:否
     */
    private Integer admin;

    /**
     * 方式
     * 1：修改
     * 2：适配：
     */
    private Integer recastMethod;

    /**
     * 报告id
     */
    private String reportId;
}
