package com.zjty.inspect.controller;

import com.alibaba.fastjson.JSON;
import com.zjty.inspect.dao.TechnologyDao;
import com.zjty.inspect.entity.*;
import com.zjty.inspect.service.*;
import com.zjty.inspect.utils.*;
import freemarker.template.TemplateException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.apache.tomcat.util.http.fileupload.disk.DiskFileItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import java.io.*;
import java.io.File;
import java.util.*;

/**
 * 评估接口
 *
 * @author mcj
 */
@Slf4j
@RestController
@RequestMapping("/inspect")
@Api(value = "评估接口管理接口", description = "评估管理接口,提供页面的增、删、改、查")
public class InspectController {
    @Autowired
    private InspectService inspectService;
    @Autowired
    private EvaluationService evaluationService;

    @Autowired
    private TechnologyService technologyService;

    @Autowired
    private ParameterService parameterService;

    @Autowired
    private ReportService reportService;

    /**
     * 上传代码进行评估
     *
     * @param years      系统开发时间
     * @param systemFund 系统开发费用
     * @param modules    模块数
     * @param valid      预算数据是否可用
     * @param framework  架构
     * @param safety     安全能力
     * @param disaster   容灾能力
     * @param data       数据量
     * @param admin      是否管理员
     * @param multfile   文件
     * @return
     * @throws IOException
     */
    @PostMapping("/path")
    @ApiOperation("上传代码进行评估")
    public ResponseEntity inspect(Integer years, Integer systemFund, Integer modules
            , String valid, Integer framework, Integer safety, Integer disaster, Integer data
            , Integer admin, String projectName, Integer tables, String databaseType, Integer method, String username, MultipartFile multfile) throws IOException {

        File file = FileUtil.saveToLocal(multfile);
        log.info("inspect:代码解压完成,地址为{}", file.getCanonicalPath());
        InspectParameter inspectParameter = new InspectParameter();

        inspectParameter.setUsername(username);
        inspectParameter.setSystemFund(systemFund);
        inspectParameter.setModules(modules);
        inspectParameter.setSafety(safety);
        inspectParameter.setTables(tables);
        inspectParameter.setValid(valid);
        inspectParameter.setYears(years);
        inspectParameter.setDisaster(disaster);
        inspectParameter.setData(data);
        inspectParameter.setFramework(framework);
        inspectParameter.setId(UUIDUtil.getUUID());
        inspectParameter.setAdmin(admin);
        inspectParameter.setSystemFund(systemFund);
        inspectParameter.setRecastMethod(method);
        inspectParameter.setSourceAddress(file.getCanonicalPath());
        ReportVo reportVo = new ReportVo();

        reportVo.setId(RandomUtil.getRandom());
        reportVo.setUploadType("文件上传");
        reportVo.setFileName(file.getName());
        reportVo.setProjectName(projectName);
        reportVo.setSourceAddress(file.getCanonicalPath());
        reportVo.setDatabaseType(databaseType);
        ReportVo inspect = inspectService.inspect(reportVo, inspectParameter);

        int count = technologyService.findAllTechnologyCount();
        reportVo.setTechnologiesNum(count);
        int support = technologyService.findAllTechnologyNotSupport();
        reportVo.setTechnologiesRepair(support);
        log.info("inspect:代码评估完成");
//        String filePath = inspectService.freemakerData(inspect,count,support);
        reportVo.setHtmlAddress(null);

        Report report = new Report();
        String random = RandomUtil.getRandom();
        report.setId(RandomUtil.getRandom());
        report.setHtmlAddress(reportVo.getHtmlAddress());
        reportService.saveReport(report);
        return ResponseEntity.ok(inspect);
    }

    /**
     * git下载代码进行评估
     *
     * @param inspectParameter 封装
     * @return
     */
    @PostMapping("/git")
    @ApiOperation("git下载代码进行评估")
    public ResponseEntity inspect1(@RequestBody InspectParameter inspectParameter) {
        String path = GitLabUtil.downLoadProject(inspectParameter.getGitAddress(), inspectParameter.getGitName());
        inspectParameter.setId(UUIDUtil.getUUID());
        inspectParameter.setSourceAddress(path);
        ReportVo reportVo = new ReportVo();
        reportVo.setUploadType("git下载");
        reportVo.setSourceAddress(path);
        reportVo.setGitAddress(inspectParameter.getGitAddress());
        ReportVo inspect = inspectService.inspect(reportVo, inspectParameter);
        return ResponseEntity.ok(inspect);
    }

    @PostMapping("/frontend")
    @ApiOperation("git下载代码进行评估")
    public ResponseEntity inspect(MultipartFile file) throws IOException {

        return ResponseEntity.ok(200);
    }

    @PostMapping("/rapidAssessment")
    public ResponseEntity rapidAssessment(@RequestBody Reform reform){
        System.out.println(JSON.toJSONString(reform));
        InspectParameter inspectParameter = new InspectParameter();
        inspectParameter.setUsername(reform.getUsername());
        inspectParameter.setValid("1");
        inspectParameter.setSourceAddress(reform.getCodeUrl());
        inspectParameter.setSystemFund(reform.getCost());
        inspectParameter.setAdmin(reform.getAdmin());
        inspectParameter.setModules(reform.getModuleNum());
        inspectParameter.setSafety(reform.getSafe());
        inspectParameter.setTables(reform.getTableNum());
        inspectParameter.setDisaster(reform.getDisasterTolerance());
        inspectParameter.setData(reform.getDatabaseNum());
        inspectParameter.setFramework(reform.getFramework());
        inspectParameter.setGitAddress(reform.getGitUrl());
        inspectParameter.setRecastMethod(reform.getMode());
        inspectParameter.setYears(reform.getTime());
        inspectParameter.setId(UUIDUtil.getUUID());
        ReportVo reportVo = new ReportVo();
        int count = technologyService.findAllTechnologyCount();
        reportVo.setTechnologiesNum(count);
        int support = technologyService.findAllTechnologyNotSupport();
        reportVo.setTechnologiesRepair(support);
        reportVo.setId(RandomUtil.getRandom());
        reportVo.setUploadType("文件上传");
        reportVo.setFileName(reform.getCodeName());
        reportVo.setProjectName(reform.getProjectName());
        reportVo.setSourceAddress(reform.getCodeUrl());
        reportVo.setDatabaseType(null);
        ReportVo inspect = inspectService.inspect(reportVo,inspectParameter);
        log.info("inspect:代码评估完成");
        Report report = new Report();
        String random = RandomUtil.getRandom();
        report.setId(RandomUtil.getRandom());
        report.setHtmlAddress(reportVo.getHtmlAddress());
        reportService.saveReport(report);
        /*
        马晨俊运算结束
         */
        System.out.println(JSON.toJSONString(inspect));
        if(inspect.getRecastMethod()==1 &&inspect.getLanguage()!=1){
            return ResponseEntity.ok(500);
        }
        /*
        将马晨俊的数据放入输出的表单
         */
        AssessmentReport assessmentReport = new AssessmentReport();
        //语言
        assessmentReport.setLanguage(inspect.getLanguage());
        //适配还是改造
        assessmentReport.setType(reform.getMode());
        SysScale sysScale = new SysScale();
        Scale scale = new Scale();
        //文件数量
        scale.setNum(inspect.getFileNum());
        sysScale.setFile(scale);
        //代码行数
        Scale scale1 = new Scale();
        scale1.setNum(inspect.getFileLine());
        sysScale.setCode(scale1);
        //模块数
        Scale scale2 = new Scale();
        scale2.setNum(reform.getModuleNum());
        sysScale.setMode(scale2);
        assessmentReport.setSysScale(sysScale);
        //系统名称
        assessmentReport.setSysName(inspect.getProjectName());
        //软件名称
        assessmentReport.setOrgName(inspect.getFileName());
        //评估时间
        assessmentReport.setTime(inspect.getCreateDate());
        //适配预算
//        assessmentReport.setBudget(inspect.getBudgets().getBudget().get(0).getFund());
        //原系统规模，马晨俊没放进去
        //技术详情，马晨俊的警告点,同时统计技术的数量
        //样式调整
        int css = 0;
        //API数量
        int api = 0;
        //插件替换数量
        int plugIn = 0;
        //jni数量
        int jni = 0;
        //中间件依赖数量
        int dependOnNum = 0;
        HashMap<String, List<Warn>> warnDetails = inspect.getWarnDetails();
        Set<String> keySet = warnDetails.keySet();
        List<TechnologyReport> technologyReports = new ArrayList<>();
        for (String key:keySet) {
            List<Warn> warns = warnDetails.get(key);
            if(warns.size()>0){
                TechnologyReport technologyReport = new TechnologyReport();
                technologyReport.setTechnology(key);
                //少一个策略
                List<TechnologyContent> technologyContents = new ArrayList<>();
                for (Warn warn:warns) {
                    TechnologyContent technologyContent = new TechnologyContent();
                    //technologyContent.setLocal(warn.get);
                    technologyContent.setFile(warn.getFilePath());
                    technologyContent.setKeyWord(warn.getRule());
                    technologyContent.setPosition(warn.getLineNum().toString());
                    String categoryId = warn.getCategoryId();
                    if(!Objects.equals(categoryId, "0") &&categoryId!=null&& Objects.equals(categoryId, "1")){
                        dependOnNum += 1;
                    }
                    technologyContents.add(technologyContent);
                }
                if(Objects.equals(key, "Microsoft CSS extensions(不支持)")){
                    css = technologyContents.size();
                }else if(Objects.equals(key, "Microsoft API extensions(不支持)")){
                    api = technologyContents.size();
                }else if(Objects.equals(key, "Microsoft JavaScript extensions(不支持)")){
                    plugIn = technologyContents.size();
                }else if(Objects.equals(key, "JNI(不支持)")){
                    jni = technologyContents.size();
                }
                technologyReport.setTechnologyContents(technologyContents);
                technologyReports.add(technologyReport);
            }
        }
        TechnologyList technologyList = new TechnologyList();
        technologyList.setDes(null);
        technologyList.setTechnologyReports(technologyReports);
        assessmentReport.setTechnologyList(technologyList);
        //额外申请
        assessmentReport.setApply(reform.getApply());

        //难度数据填写
        DifficultyAssessment difficultyAssessment = new DifficultyAssessment();
        //系统部署架构难度,reform中获取
        FrameDifficulty frameDifficulty = new FrameDifficulty();
        frameDifficulty.setDetails(inspect.getFramework());
        SystemStructure systemStructure = reform.getSystemStructure();
        frameDifficulty.setDisaster(systemStructure.getDisaster());
        frameDifficulty.setDistributed(systemStructure.getDistributed());
        frameDifficulty.setLoadBalance(systemStructure.getLoadBalance());
        frameDifficulty.setOtherDemand(systemStructure.getOtherDemand());
        difficultyAssessment.setFrameDifficulty(frameDifficulty);
        //浏览器难度
        BrowserDifficulty browserDifficulty = new BrowserDifficulty();
        browserDifficulty.setApi(api);
        browserDifficulty.setStyle(css);
        browserDifficulty.setPlugInUnit(plugIn);
        Browser browser = reform.getBrowser();
        browserDifficulty.setOtherDemand(browser.getOtherDemand());
        browserDifficulty.setGeography(browser.getGeography());
        browserDifficulty.setPeripheral(browser.getPeripheral());
        browserDifficulty.setAnimation(browser.getAnimation());
        browserDifficulty.setThreeD(browser.getThreeD());
        browserDifficulty.setDocument(browser.getDocument());
        browserDifficulty.setMedia(browser.getMedia());
        browserDifficulty.setFlash(browser.getFlash());
        System.out.println("BrowserDifficulty:"+JSON.toJSONString(browserDifficulty));
        difficultyAssessment.setBrowserDifficulty(browserDifficulty);
        //中间件难度
        MiddlewareDifficulty middlewareDifficulty = new MiddlewareDifficulty();
        //所有的依赖
        List<PomDependency> dependencies = new ArrayList<>();
        List<ProjectPom> depTreeList = inspect.getDependencyVo().getDepTreeList();
        for (ProjectPom projectPom : depTreeList) {
            dependencies.addAll(projectPom.getDependencies());
        }

//        HashMap<String,Integer> num = new HashMap<>();
//        for (PomDependency pomDependency:dependencies) {
//            String groupId = pomDependency.getGroupId();
//            Integer integer = num.get(groupId);
//            if(integer == null){
//                num.put(groupId,1);
//            }else{
//                integer = integer+1;
//                num.put(groupId,integer);
//            }
//        }
//        System.out.println("所有依赖："+JSON.toJSONString(num));
//        Set<String> strings = num.keySet();
//        List<DependOnNum> dependOnNums = new ArrayList<>();
//        for (String s:strings) {
//            DependOnNum dependOnNum = new DependOnNum();
//            dependOnNum.setName(s);
//            dependOnNum.setNum(num.get(s));
//            dependOnNums.add(dependOnNum);
//        }
        middlewareDifficulty.setDependOnNum(dependOnNum);
        Middleware middleware = reform.getMiddleware();
        middlewareDifficulty.setWeb(middleware.getWeb());
        middlewareDifficulty.setJms(middleware.getJms());
        middlewareDifficulty.setJndi(middleware.getJndi());
        middlewareDifficulty.setRoute(middleware.getRoute());
        System.out.println("middlewareDifficulty"+JSON.toJSONString(middlewareDifficulty));
        difficultyAssessment.setMiddlewareDifficulty(middlewareDifficulty);
        //数据库难度
        DatabaseDifficulty databaseDifficulty = new DatabaseDifficulty();
        Database database = reform.getDatabase();
        databaseDifficulty.setDisasterTolerance(database.getDisasterTolerance());
        databaseDifficulty.setSafe(database.getSafe());
        databaseDifficulty.setSeparate(database.getSeparate());
        databaseDifficulty.setPerformance(database.getPerformance());
        databaseDifficulty.setOtherContent(database.getOtherContent());
        difficultyAssessment.setDatabaseDifficulty(databaseDifficulty);
        //本地程序难度
        ProgramDifficulty programDifficulty = new ProgramDifficulty();
        List<DependOnNum> dependOns = new ArrayList<>();
        DependOnNum dependOnNum2 = new DependOnNum("jni",jni);
        dependOns.add(dependOnNum2);
        programDifficulty.setDependOnNum(dependOns);
        difficultyAssessment.setProgramDifficulty(programDifficulty);
        System.out.println("programDifficulty+:"+JSON.toJSONString(programDifficulty));
        assessmentReport.setDifficultyAssessment(difficultyAssessment);
        WorkLoadUtil workLoadUtil = new WorkLoadUtil();
        //r:人工费
        RestTemplate restTemplate = new RestTemplate();
        //restTemplate.exchange("localhost:8079/config", HttpMethod.GET,new HttpEntity<>())
        //计算f
        Budget budget = inspect.getBudgets().getBudget().get(0);
        double f = budget.getProportion()*budget.getSysFund()*budget.getMoneyRate()*budget.getCoefficient();
        System.out.println("F:"+f);
        workLoadUtil.result(reform, assessmentReport, f, 1.5);
        Evaluation evaluation=new Evaluation();
        //输入参数
        String in = JSON.toJSONString(reform);
        //输出参数
        String out = JSON.toJSONString(assessmentReport);

        evaluation.setInEva(in);
        evaluation.setOutEva(out);
        evaluation.setUsername(reform.getUsername());
        evaluationService.save(evaluation);
        return ResponseEntity.ok(assessmentReport);
    }

    @PostMapping("/uploads")
    private ResponseEntity uploads(@RequestParam(value = "file") MultipartFile multfile){
        try {
            File file = FileUtil.saveToLocal(multfile);
            String name = file.getName();
            String path = file.getCanonicalPath();
            return ResponseEntity.ok(new com.zjty.inspect.entity.File(name,path));
        } catch (IOException e) {
            e.printStackTrace();
            return ResponseEntity.ok("上传失败");
        }
    }
}
