package com.zjty.inspect.service.impl;

import com.zjty.inspect.dao.ParameterDao;
import com.zjty.inspect.entity.InspectParameter;
import com.zjty.inspect.service.ParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Objects;
import java.util.Optional;

/**
 * 参数
 * @author Mcj
 * @date 2020-02-27 21:36
 */

@Service
@Transactional(rollbackFor = Exception.class)
public class ParameterServiceImpl implements ParameterService {

    @Autowired
    private ParameterDao parameterDao;

    @Override
    public void saveParameter(InspectParameter inspectParameter) {
        parameterDao.save(inspectParameter);
    }

    @Override
    public InspectParameter getParameterById(String id) {
        if(parameterDao.findById(id).isPresent()){
            return parameterDao.findById(id).get();
        }
        return new InspectParameter();
    }

    /**
     * 根据用户名查询参数
     * @param username 用户名
     * @return 参数
     */
    @Override
    public InspectParameter getParameterByUsername(String username) {
        InspectParameter inspectParameter = parameterDao.findByUsernameEquals(username);
        return inspectParameter;
    }
}
