package com.zjty.inspect.controller;

import com.zjty.inspect.entity.PageResult;
import com.zjty.inspect.entity.Rule;
import com.zjty.inspect.entity.RuleQo;
import com.zjty.inspect.service.RuleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * 规则库设置
 * @author Mcj
 * @date 2020-02-26 14:42
 */

@RestController
@RequestMapping("/rule")
@Api(value = "规则页面管理接口",description = "规则页面管理接口,提供页面的增、删、改、查")
public class RuleController {

    @Autowired
    private RuleService ruleService;

    /**
     * 新增规则
     * @param ruleQo 规则封装
     * @return
     */
    @PostMapping
    @ApiOperation("新增规则")
    public ResponseEntity rule(@RequestBody RuleQo ruleQo){
        ruleService.addRule(ruleQo);
        return ResponseEntity.ok(200);
    }
    /**
     * 修改规则
     * @param ruleQo 规则封装
     * @param id id
     * @return
     */
    @PostMapping(value = "/{id}")
    @ApiOperation("修改规则")
    public ResponseEntity update(@RequestBody RuleQo ruleQo,@PathVariable String id){
        ruleQo.setId(id);
        ruleService.upRule(ruleQo);
        return ResponseEntity.ok(200);
    }
    /**
     * 根据id删除规则
     * @param id id
     * @return
     */
    @ApiOperation("根据id删除规则")
    @DeleteMapping(value = "/{id}")
    public ResponseEntity deleteById(@PathVariable String id){
        ruleService.deleteById(id);
        return ResponseEntity.ok(200);
    }
    @ApiOperation("根据name查询规则")
    @GetMapping(value = "/{name}")
    public ResponseEntity getName(@PathVariable String name) {
        return ResponseEntity.ok(ruleService.findByName(name));
    }
    /**
     * 查询所有规则
     * @return 规则
     */
    @ApiOperation("查询所有规则")
    @GetMapping
    public ResponseEntity getRules(){
        return ResponseEntity.ok(ruleService.findAll());
    }

    /**
     * 查询所有规则
     * @return 规则
     */
    @ApiOperation("查询所有规则")
    @GetMapping("/test")
    public ResponseEntity test(){
        ruleService.test();
        return ResponseEntity.ok(200);
    }
    /**
     * 分页+多条件查询
     * @param searchMap 查询条件封装
     * @param page 页码
     * @param size 页大小
     * @return 分页结果
     */
    @ApiOperation("分页查询页面列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name="page",value = "页码",required=true,paramType="path",dataType="int"),
            @ApiImplicitParam(name="size",value = "每页记录数",required=true,paramType="path",dataType="int")
    })
    @RequestMapping(value="/search/{page}/{size}",method=RequestMethod.POST)
    public ResponseEntity findSearch(@RequestBody Map searchMap , @PathVariable int page, @PathVariable int size){
        Page<Rule> pageList = ruleService.findSearch(searchMap, page, size);
        return  ResponseEntity.ok(new PageResult<Rule>(pageList.getTotalElements(), pageList.getContent()) );
    }
}
