package com.zjty.inspect.utils;

import com.alibaba.fastjson.JSON;
import com.zjty.inspect.entity.*;
import com.zjty.inspect.enums.*;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author Mcj
 * @date 2019-07-17 16:52
 */

public class ExcelUtil {

    private static String xlsx = "xlsx";
    private static String xls = "xls";

    private static List<ExcelDataEntity> arrayList;

    public static Reform parseExcel(InputStream fileInputStream, String fileName) {
        Reform reform = new Reform();
        try {
            String[] split = Objects.requireNonNull(fileName).split("\\.");
            if (xlsx.equals(split[1])) {
                XSSFWorkbook xwb = new XSSFWorkbook(fileInputStream);
                //3、得到Excel工作表对象
                XSSFSheet sheetAt = xwb.getSheetAt(0);
                reform = getReform(sheetAt);

            } else if (xls.equals(split[1])) {
                HSSFWorkbook xwb = new HSSFWorkbook(fileInputStream);
                //3、得到Excel工作表对象
                HSSFSheet sheetAt = xwb.getSheetAt(0);
                reform = getReform(sheetAt);
            }

        } catch (IOException e) {
            e.printStackTrace();
        }
        return reform;
    }

    private static String getExcelCell(int rowNum, int cellNum, Sheet sheetAt) {
        Row row = sheetAt.getRow(rowNum);
        Cell cell = row.getCell(cellNum);
        return cell.toString();
    }

    private static Reform getReform(Sheet sheetAt) {
        Reform reform = new Reform();
        //单位名称
        String unitName = getExcelCell(2, 2, sheetAt);
        reform.setUnitName(unitName);
        //单位联系方式
        String unitPhone = getExcelCell(2, 4, sheetAt);
        String[] split = unitPhone.split("\n");
        if (split.length > 1) {
            reform.setUnitContent(split[0]);
            reform.setUnitPhone(split[1]);
        }

        reform.setUnitName(unitName);

        //系统名称
        String projectName = getExcelCell(3, 2, sheetAt);
        reform.setProjectName(projectName);
        String cost = getExcelCell(4, 2, sheetAt);
        double i1 = returnDouble(cost);
        reform.setCost((int) i1);
        String cycle = getExcelCell(5, 2, sheetAt);
        String s = cycle.replaceAll("年", "");

        reform.setCycle(returnNum(s) * 12);

        String time = getExcelCell(6, 2, sheetAt);
        if (!"".equals(time)) {
            if ("10年以上".equals(time)) {
                reform.setTime(11);
            } else {
                String year = time.replaceAll("年", "");
                Integer newYear = Integer.valueOf(year);
                reform.setTime(newYear*12);
            }
        }
        String address = getExcelCell(7, 2, sheetAt);
        reform.setAddress(yesOrNo(address));
        String nativeContent = getExcelCell(7, 4, sheetAt);
        String[] nativeUnit = nativeContent.split("\n");
        if (nativeUnit.length > 0) {
            reform.setLocalContact(nativeUnit[0]);
            reform.setLocalPhone(nativeUnit[1]);
        }

        String secret = getExcelCell(8, 2, sheetAt);
        reform.setSecret(yesOrNo(secret));

        String gradeProtection = getExcelCell(9, 2, sheetAt);
        reform.setGradeProtection(yesOrNo(gradeProtection));

        String construction = getExcelCell(10, 2, sheetAt);
        reform.setFramework( getFramework(construction));

        String disaster = getExcelCell(11, 2, sheetAt);
        int i2 = SpecialYesOrNo(disaster);
        reform.setDisasterTolerance(i2);

        String type = getExcelCell(12, 2, sheetAt);
        ArrayList<Integer> applicationType = new ArrayList<>();

        switch (type) {
            case "办公OA应用类":
                applicationType.add(1);
                break;
            case "门户、信息发布、综合入口服务类":
                applicationType.add(2);
                break;
            case "申报、填报、审批等公共行政服务类":
                applicationType.add(4);
                break;
            case "数据收集、分析、态势感知等大数据应用类":
                applicationType.add(5);
                break;
            case "地图、定位等GIS服务类":
                applicationType.add(6);
                break;
            case "视频、图形等流媒体应用类":
                applicationType.add(7);
                break;
            case "3D、模型等视觉建模应用类":
                applicationType.add(8);
                break;
        }
        reform.setApplicationType(applicationType);

        String module = getExcelCell(13, 2, sheetAt);
        reform.setModuleNum((int) returnDouble(module));
        String mode = getExcelCell(15, 2, sheetAt);
        if ("终端适配".equals(mode)) {
            reform.setMode(2);
        } else {
            reform.setMode(1);
        }
        DevelopLanguageSystem developLanguageSystem = new DevelopLanguageSystem();
        List<BaseDes> devFrameworks = new ArrayList<>();
        for (int i = 17; i < 22; i++) {
            String framework = getExcelCell(i, 2, sheetAt);

            if ("".equals(framework)) {
                continue;
            }
            String version = getExcelCell(i, 3, sheetAt);
            String remark = getExcelCell(i, 4, sheetAt);
            BaseDes devFramework = new BaseDes();
            FrameWorkEnum frameWorkEnum = FrameWorkEnum.getByName(framework);
            if (frameWorkEnum != null) {
                devFramework.setCode(frameWorkEnum.getCode());
                devFramework.setVersion(version);
                devFramework.setDes(remark);
                devFrameworks.add(devFramework);
            }
        }
        developLanguageSystem.setDevFrameworks(devFrameworks);


        List<BaseDes> fontTechnologies = new ArrayList<>();
        for (int i = 22; i < 27; i++) {
            String framework = getExcelCell(i, 2, sheetAt);
            if ("".equals(framework)) {
                continue;
            }
            String version = getExcelCell(i, 3, sheetAt);
            String remark = getExcelCell(i, 4, sheetAt);
            BaseDes font = new BaseDes();
            FontTechnologyEnum fontTechnologyEnum = FontTechnologyEnum.getByName(framework);
            if (fontTechnologyEnum != null) {
                font.setCode(fontTechnologyEnum.getCode());
                font.setName(framework);
                font.setDes(remark);
                font.setVersion(version);
                fontTechnologies.add(font);
            }
        }
        developLanguageSystem.setFontDevTechnologies(fontTechnologies);

        List<BaseDes> fontDevTechnologies = new ArrayList<>();
        for (int i = 28; i < 33; i++) {
            String framework = getExcelCell(i, 2, sheetAt);
            if ("".equals(framework)) {
                continue;
            }
            String version = getExcelCell(i, 3, sheetAt);
            String remark = getExcelCell(i, 4, sheetAt);
            BaseDes cs = new BaseDes();
            cs.setDes(remark);
            cs.setVersion(version);
            CSTechnologyEnum csTechnologyEnum = CSTechnologyEnum.getByName(framework);
            if (csTechnologyEnum != null) {
                cs.setCode(csTechnologyEnum.getCode());
                cs.setName(csTechnologyEnum.getName());
                fontDevTechnologies.add(cs);
            }
        }
        developLanguageSystem.setCsDevTechnologies(fontDevTechnologies);

        List<BaseDes> opGAS = new ArrayList<>();
        for (int i = 34; i < 39; i++) {
            String framework = getExcelCell(i, 2, sheetAt);
            if ("".equals(framework)) {
                continue;
            }
            String version = getExcelCell(i, 3, sheetAt);
            String remark = getExcelCell(i, 4, sheetAt);
            BaseDes opGA = new BaseDes();
            OpgaEnum opgaEnum = OpgaEnum.getByName(framework);
            if (opgaEnum != null) {
                opGA.setName(framework);
                opGA.setCode(opgaEnum.getCode());
                opGA.setVersion(version);
                opGA.setDes(remark);
                opGAS.add(opGA);
            }
        }
        developLanguageSystem.setOpGAs(opGAS);

        String language = getExcelCell(39, 2, sheetAt);
        developLanguageSystem.setCode(MainLanguageEnum.getByName(language).getCode());
        developLanguageSystem.setName(MainLanguageEnum.getByName(language).getName());

        ArrayList<BaseDes> devLanguages = new ArrayList<>();
        for (int i = 40; i < 45; i++) {
            String lan = getExcelCell(i, 2, sheetAt);
            if ("".equals(lan)) {
                continue;
            }
            String version = getExcelCell(i, 3, sheetAt);
            String remark = getExcelCell(i, 4, sheetAt);
            BaseDes devLanguage = new BaseDes();
            LanguageEnum languageEnum = LanguageEnum.getByName(lan);
            if (languageEnum != null) {
                devLanguage.setName(languageEnum.getName());
                devLanguage.setCode(languageEnum.getCode());
                devLanguage.setVersion(version);
                devLanguage.setDes(remark);
                devLanguages.add(devLanguage);
            }
        }
        developLanguageSystem.setDevLanguages(devLanguages);

        reform.setDevelopLanguageSystem(developLanguageSystem);
        /**
         * 中间件/API
         */
        Middleware middleware = new Middleware();
        List<MiddlewareEnum> middlewareEnums = new ArrayList<>();
        for (int i = 46; i < 51; i++) {
            String middleware1 = getExcelCell(i, 2, sheetAt);
            if (!"".equals(middleware1)) {
                MiddlewareEnum middlewareEnum = MiddlewareEnum.getByName(middleware1);
                if (middlewareEnum != null) {
                    middlewareEnums.add(middlewareEnum);
                }
            }
        }
        middleware.setMiddlewareEnums(middlewareEnums);

        ArrayList<OtherApi> otherApis = new ArrayList<>();
        for (int i = 51; i < 61; i++) {
            String api = getExcelCell(i, 2, sheetAt);
            if ("".equals(api)) {
                continue;
            }
            String version = getExcelCell(i, 3, sheetAt);
            String remark = getExcelCell(i, 4, sheetAt);
            OtherApi otherApi = new OtherApi();
            otherApi.setApiName(api);
            otherApi.setDes(remark);
            otherApi.setVersion(version);
            otherApi.setCode(String.valueOf(OtherApiEnum.getByName(api).getCode()));
            otherApis.add(otherApi);
        }
        middleware.setOtherApis(otherApis);

        List<BaseDes> microServices = new ArrayList<>();
        for (int i = 62; i < 72; i++) {
            String name = getExcelCell(i, 2, sheetAt);
            if (name == null || "".equals(name)) {
                continue;
            }
            String version = getExcelCell(i, 3, sheetAt);
            String remark = getExcelCell(i, 4, sheetAt);
            BaseDes microService = new BaseDes();
            MicroServiceEnum microServiceEnum = MicroServiceEnum.getByName(name);
            if (microServiceEnum != null) {
                microService.setCode(microServiceEnum.getCode());
                microService.setName(microServiceEnum.getName());
                microService.setDes(remark);
                microService.setVersion(version);
                microServices.add(microService);
            }
        }
        middleware.setMicroServices(microServices);

        reform.setMiddleware(middleware);
        //数据库相关
        Database database1 = new Database();
        ArrayList<DatabaseType> databaseTypes = new ArrayList<>();
        for (int i = 74; i < 77; i++) {
            String database = getExcelCell(i, 2, sheetAt);
            if (!"".equals(database)) {
                DatabaseType byName = DatabaseType.getByName(database);
                databaseTypes.add(byName);
            }
        }
        database1.setDatabaseType(databaseTypes);

        String tableNum = getExcelCell(77, 2, sheetAt);
        if ("".equals(tableNum)) {
            reform.setTableNum(0);
        } else {
            reform.setTableNum(Integer.valueOf(tableNum));
        }

        String sp = getExcelCell(81, 2, sheetAt);
        database1.setSeparate(yesOrNo(sp));
        String dblink = getExcelCell(82, 2, sheetAt);
        database1.setDbLink(yesOrNo(dblink));
        String view = getExcelCell(83, 2, sheetAt);
        database1.setView(yesOrNo(view));
        String storage = getExcelCell(84, 2, sheetAt);
        database1.setStorage(yesOrNo(storage));
        String function = getExcelCell(85, 2, sheetAt);
        database1.setFunction(yesOrNo(function));
        String timeTask = getExcelCell(86, 2, sheetAt);
        database1.setTimeTask(yesOrNo(timeTask));
        String sequence = getExcelCell(87, 2, sheetAt);
        database1.setSequence(yesOrNo(sequence));
        String trigger = getExcelCell(88, 2, sheetAt);
        database1.setTrigger(yesOrNo(trigger));
        String disasterTolerance = getExcelCell(89, 2, sheetAt);
        database1.setDisasterTolerance(yesOrNo(disasterTolerance));
        String safe = getExcelCell(90, 2, sheetAt);
            database1.setSafe(yesOrNo(safe));
        String performance = getExcelCell(91, 2, sheetAt);
        if (!"无".equals(performance)) {
            database1.setPerformance(1);
        }
        reform.setDatabase(database1);

        Browser browser = new Browser();
        List<CompatibleBrowser> compatibleBrowsers = new ArrayList<>();
        for (int i = 93; i <= 97; i++) {
            String brows = getExcelCell(i, 2, sheetAt);
            compatibleBrowsers.add(CompatibleBrowser.getByName(brows));
        }
        browser.setCompatibleBrowsers(compatibleBrowsers);

        ArrayList<BaseDes> browserPlugs = new ArrayList<>();

        for (int i = 98; i <= 108; i++) {
            String plugin = getExcelCell(i, 2, sheetAt);
            BaseDes browserPlug = new BaseDes();
            String version = getExcelCell(i, 3, sheetAt);
            String remark = getExcelCell(i, 4, sheetAt);
            browserPlug.setVersion(version);
            browserPlug.setDes(remark);

            BrowserPlugEnum byName = BrowserPlugEnum.getByName(plugin);
            browserPlug.setName(byName.getName());
            browserPlug.setCode(byName.getCode());

            switch (plugin) {
                case "在线文本编辑类：请在备注中填写插件名和版本":
                    break;
                case "打印调用":
                case "扫描调用":
                    browser.setPeripheral(1);
                    break;
                case "在线3D建模、渲染、展现：请在备注中填写插件名和版本":
                    browser.setThreeD(1);
                    break;
                case "在线视频播放类：请在备注中填写插件名和版本":
                    browser.setMedia(1);
                    break;
                default:
                    browser.setOtherDemand(1);
                    break;
            }
            browserPlugs.add(browserPlug);
        }
        browser.setBrowserPlugs(browserPlugs);
        reform.setBrowser(browser);

        String apply = getExcelCell(110, 2, sheetAt);
        Apply apply1 = new Apply();
        apply1.setCost(Double.valueOf(apply));
        String remark = getExcelCell(110, 3, sheetAt);
        apply1.setReason(remark);
        reform.setApply(apply1);
        SystemStructure systemStructure = new SystemStructure();

        Details sysDetails = getSysDetails(113, 2, sheetAt);
        systemStructure.setApplication(sysDetails);

        Details rdsdetails = getSysDetails(114, 2, sheetAt);
        systemStructure.setDatabase(rdsdetails);

        Details nasdetails = getSysDetails(115, 2, sheetAt);
        systemStructure.setNas(nasdetails);

        Details slbdetails = getSysDetails(116, 2, sheetAt);
        systemStructure.setSlb(slbdetails);

        Details cdndetails = getSysDetails(117, 2, sheetAt);
        systemStructure.setCdn(cdndetails);

        Details vpsdetails = getSysDetails(118, 2, sheetAt);
        systemStructure.setVps(vpsdetails);

        reform.setSystemStructure(systemStructure);

        String rpo = getExcelCell(121, 2, sheetAt);
        RtoEnum rtoEnum = RtoEnum.getByName(rpo);
        if (rtoEnum != null) {
            reform.setRto(rtoEnum.getCode());
        }
        String rto = getExcelCell(122, 2, sheetAt);
        RpoEnum rpoEnum = RpoEnum.getByName(rto);
        if (rpoEnum != null) {
            reform.setRpo(rpoEnum.getCode());
        }
        int max = Math.max(rpoEnum.getCode(), rtoEnum.getCode());
        if(max==1){
            reform.setStrategy(3);
        }else if(max<=5){
            reform.setStrategy(1);
        }else {
            reform.setStrategy(2);
        }
        return reform;
    }

    public static List<ExcelDataTemp> parseExcel2Entity(Evaluation evaluation) {
        ArrayList<ExcelDataTemp> excelDataTemps = new ArrayList<>();
        String inEva = evaluation.getInEva();
        ExcelDataTemp excelDataTemp = new ExcelDataTemp();
        excelDataTemp.setName("基本信息");
        List<ExcelDataEntity> arrayList = excelDataTemp.getArrayList();
        if (inEva != null) {
            Reform reform = JSON.parseObject(evaluation.getInEva(), Reform.class);
            arrayList.add(exportEntity("用户名", reform.getUsername()));
            if(reform.getAssessmentType()==1){
                arrayList.add(exportEntity("评估类型", "快速评估"));
            }else{
                arrayList.add(exportEntity("评估类型", "详细评估"));
            }
            if(reform.getMode()==1){
                arrayList.add(exportEntity("替换方式", "改造"));
            }else{
                arrayList.add(exportEntity("替换方式", "适配"));
            }
            arrayList.add(exportEntity("系统名称", reform.getProjectName()));
            arrayList.add(exportEntity("代码地址", reform.getCodeUrl()));
            arrayList.add(exportEntity("文件名称", reform.getCodeName()));
            arrayList.add(exportEntity("git地址", reform.getGitUrl()));
            arrayList.add(exportEntity("模块数量", reform.getModuleNum()));
            arrayList.add(exportEntity("原开发费用", reform.getCost()));
            arrayList.add(exportEntity("开发单位是否在本地", flipYesOrNo(reform.getAddress())));
            arrayList.add(exportEntity("开发单位联系人", reform.getLocalContact()));
            arrayList.add(exportEntity("开发单位联系方式", reform.getLocalPhone()));
            arrayList.add(exportEntity("是否涉密系统", flipYesOrNo(reform.getSecret())));

            arrayList.add(exportEntity("容灾能力", flipSpecialYesOrNo(reform.getDisasterTolerance())));
            arrayList.add(exportEntity("安全能力", flipSafeYesOrNo(reform.getSafe())));
            arrayList.add(exportEntity("架构", getFilpFramework(reform.getFramework())));
            arrayList.add(exportEntity("运行时间", reform.getTime()));
            arrayList.add(exportEntity("数据库表数量", reform.getTableNum()));
            arrayList.add(exportEntity("数据库数据量", reform.getDatabaseNum()));
            List<Integer> applicationType = reform.getApplicationType();
            for (Integer type : applicationType) {
                ApplicationType applicationType1 = ApplicationType.getByCode(type);
                arrayList.add(exportEntity("该应用类型", applicationType1.getName()));
            }

            excelDataTemps.add(excelDataTemp);

            SystemStructure systemStructure = reform.getSystemStructure();

            ExcelDataTemp deployTemp = new ExcelDataTemp();
            deployTemp.setName("原应用部署环境");
            List<ExcelDataEntity> deployList = excelDataTemp.getArrayList();
            deployList.addAll(getSystemData("ecs服务器", systemStructure.getApplication()));
            deployList.addAll(getSystemData("rds服务器", systemStructure.getDatabase()));
            deployList.addAll(getSystemData("nas服务器", systemStructure.getNas()));
            deployList.addAll(getSystemData("slb服务器", systemStructure.getSlb()));
            deployList.addAll(getSystemData("cdn服务器", systemStructure.getCdn()));
            deployList.addAll(getSystemData("vps服务器", systemStructure.getVps()));
            excelDataTemps.add(deployTemp);

            ExcelDataTemp browserTemp = new ExcelDataTemp();
            browserTemp.setName("前端浏览器相关");
            List<ExcelDataEntity> browserList = browserTemp.getArrayList();
            Browser browser = reform.getBrowser();
            for (CompatibleBrowser compatibleBrowser : browser.getCompatibleBrowsers()) {
                browserList.add(exportEntity("原兼容的浏览器", compatibleBrowser.getName()));
            }
            for (BaseDes browserPlug : browser.getBrowserPlugs()) {
                browserList.add(exportEntity("浏览器插件", browserPlug.getName()));
            }
            excelDataTemps.add(browserTemp);
            ExcelDataTemp middleTemp = new ExcelDataTemp();
            middleTemp.setName("中间件相关");
            List<ExcelDataEntity> middleList = middleTemp.getArrayList();
            Middleware middleware = reform.getMiddleware();
            for (MiddlewareEnum middlewareEnum : middleware.getMiddlewareEnums()) {
                middleList.add(exportEntity("原中间件", middlewareEnum.getName()));
            }
            for (OtherApi otherApi : middleware.getOtherApis()) {
                middleList.add(exportEntity("原第三方api", otherApi.getApiName()));
            }
            for (BaseDes baseDes : middleware.getMicroServices()) {
                middleList.add(exportEntity("原额外微服务", baseDes.getName()));
            }
            excelDataTemps.add(middleTemp);
            ExcelDataTemp databseTemp = new ExcelDataTemp();
            databseTemp.setName("数据库相关");
            List<ExcelDataEntity> databaseList = databseTemp.getArrayList();
            Database database = reform.getDatabase();
            for (DatabaseType databaseType : database.getDatabaseType()) {
                databaseList.add(exportEntity("数据库类型", databaseType.getName()));
            }
            databaseList.add(exportEntity("视图", flipYesOrNo(database.getView())));
            databaseList.add(exportEntity("存储过程", flipYesOrNo(database.getStorage())));
            databaseList.add(exportEntity("函数", flipYesOrNo(database.getFunction())));
            databaseList.add(exportEntity("视图", flipYesOrNo(database.getView())));
            databaseList.add(exportEntity("dblink", flipYesOrNo(database.getDbLink())));
            databaseList.add(exportEntity("定时任务", flipYesOrNo(database.getTimeTask())));
            databaseList.add(exportEntity("序列", flipYesOrNo(database.getSequence())));
            databaseList.add(exportEntity("触发器", flipYesOrNo(database.getTrigger())));
            databaseList.add(exportEntity("容灾", flipYesOrNo(database.getDisasterTolerance())));
            databaseList.add(exportEntity("安全", flipYesOrNo(database.getSafe())));
            databaseList.add(exportEntity("高性能", flipYesOrNo(database.getPerformance())));
            databaseList.add(exportEntity("读写分离", flipYesOrNo(database.getSeparate())));
            excelDataTemps.add(databseTemp);

            ExcelDataTemp languageTemp = new ExcelDataTemp();
            languageTemp.setName("原开发语言体系相关");
            List<ExcelDataEntity> languageList = languageTemp.getArrayList();
            DevelopLanguageSystem developLanguageSystem = reform.getDevelopLanguageSystem();
            languageList.add(exportEntity("原开发语言", developLanguageSystem.getName()));
            for (BaseDes devLanguage : developLanguageSystem.getDevLanguages()) {
                languageList.add(exportEntity("其他开发语言", devLanguage.getName()));
            }
            for (BaseDes devFramework : developLanguageSystem.getDevFrameworks()) {
                languageList.add(exportEntity("原应用主要开发架构", devFramework.getName()));
            }
            for (BaseDes devFramework : developLanguageSystem.getFontDevTechnologies()) {
                languageList.add(exportEntity("原前端应用主要开发架构/bs", devFramework.getName()));
            }
            for (BaseDes devFramework : developLanguageSystem.getCsDevTechnologies()) {
                languageList.add(exportEntity("原前端应用主要开发架构/cs", devFramework.getName()));
            }
            for (BaseDes opgas : developLanguageSystem.getOpGAs()) {
                languageList.add(exportEntity("原封装方式", opgas.getName()));
            }
            excelDataTemps.add(languageTemp);

            ExcelDataTemp applyTemp = new ExcelDataTemp();
            applyTemp.setName("额外申请");
            List<ExcelDataEntity> applyList = applyTemp.getArrayList();
            Apply apply = reform.getApply();
            applyList.add(exportEntity("额外申请金额", apply.getCost()));
            applyList.add(exportEntity("额外申请原因", apply.getReason()));
            excelDataTemps.add(applyTemp);

        }

        return excelDataTemps;
    }

    private static int getFramework(String construction) {
        switch (construction) {
            case "B/S":
                return 1;
            case "C/S":
                return 2;
            case "单机运行":
                return 0;
            case "分布式":
                return 4;
        }
        return -1;
    }
    private static String getFilpFramework(int construction) {
        switch (construction) {
            case 1:
                return "B/S";
            case 2:
                return "C/S";
            case 0:
                return "单机运行";
            case 4:
                return "分布式";
        }
        return "";
    }

    private static int yesOrNo(String target) {
        if ("是".equals(target)) {
            return 1;
        } else if ("否".equals(target)) {
            return 2;
        } else {
            return -1;
        }
    }
    private static int SpecialYesOrNo(String target) {
        if ("是".equals(target)) {
            return 4;
        } else if ("否".equals(target)) {
            return 0;
        } else {
            return -1;
        }
    }
    private static String flipYesOrNo(Integer target) {
        if (target == 1) {
            return "是";
        } else if (target == 2) {
            return "否";
        } else {
            return "我不清楚";
        }
    }
    private static String flipSafeYesOrNo(Integer target) {
        if(target==null){
            return "否";
        }
        if (target == 4) {
            return "强";
        } else if (target == 2) {
            return "弱";
        } else {
            return "我不清楚";
        }
    }
    private static String flipSpecialYesOrNo(Integer target) {
        if (target == 4) {
            return "是";
        } else if (target == 0) {
            return "否";
        } else {
            return "我不清楚";
        }
    }

    private static int returnNum(String target) {
        if (!"".equals(target)) {
            return Integer.valueOf(target);
        } else {
            return 0;
        }
    }

    private static double returnDouble(String target) {
        if (!"".equals(target)) {
            return Double.valueOf(target);
        } else {
            return 0;
        }
    }

    private static String getDeploy(Integer target) {
        if (target == 1) {
            return "本地";
        } else if (target == 2) {
            return "政务云";
        } else {
            return "我不清楚";
        }
    }

    private static List<ExcelDataEntity> getSystemData(String name, Details application) {
        ArrayList<ExcelDataEntity> excelDataEntities = new ArrayList<>();
        if (application != null) {
            excelDataEntities.add(exportEntity(name + "部署情况", getDeploy(application.getDeploy())));
            excelDataEntities.add(exportEntity(name + "操作系统", application.getOperateSystem().getName()));
            excelDataEntities.add(exportEntity(name + "台数", application.getNum()));
            excelDataEntities.add(exportEntity(name + "cpu个数", application.getCpuNum()));
            excelDataEntities.add(exportEntity(name + "主频", application.getGhz()));
            excelDataEntities.add(exportEntity(name + "服务器空间", application.getSpace()));
            excelDataEntities.add(exportEntity(name + "内存", application.getMemory()));
        }
        return excelDataEntities;
    }

    private static Details getSysDetails(int rowNum, int cellNum, Sheet sheetAt) {
        Details details = new Details();
        String slb = getExcelCell(rowNum, cellNum, sheetAt);

        if ("本地".equals(slb)) {
            details.setDeploy(1);
        } else if ("政务云".equals(slb)) {
            details.setDeploy(2);
        }
        String num3 = getExcelCell(rowNum, cellNum + 1, sheetAt);
        details.setNum(returnNum(num3));

        String slbsys = getExcelCell(rowNum, cellNum + 2, sheetAt);
        OperateSystem slbByName = OperateSystem.getByName(slbsys);
        details.setOperateSystem(slbByName);
        details.setCode(slbByName.getCode());
        String cpu3 = getExcelCell(rowNum, cellNum + 3, sheetAt);
        details.setCpuNum(returnNum(cpu3));
        String ghz3 = getExcelCell(rowNum, cellNum + 4, sheetAt);
        details.setGhz(ghz3);
        String space3 = getExcelCell(rowNum, cellNum + 5, sheetAt);
        details.setSpace(returnDouble(space3));
        return details;
    }

    private static ExcelDataEntity exportEntity(String name, Object value) {
        ExcelDataEntity excelDataEntity = new ExcelDataEntity();
        excelDataEntity.setName(name);
        if (value != null) {
            excelDataEntity.setValue(value.toString());
        }
        return excelDataEntity;
    }
}

