package com.zjty.inspect.service.impl;

import com.zjty.inspect.dao.ReportDao;
import com.zjty.inspect.entity.*;
import com.zjty.inspect.enums.LanguageEnum;
import com.zjty.inspect.service.InspectService;
import com.zjty.inspect.inspect.Inspector;
import com.zjty.inspect.service.ParameterService;
import com.zjty.inspect.service.TechnologyService;
import com.zjty.inspect.utils.FileUtil;
import com.zjty.inspect.utils.FreemarkerUtils;
import com.zjty.inspect.utils.TimeUtil;
import freemarker.cache.StringTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 解析
 * @author mcj
 */
@Service
public class InspectServiceImpl implements InspectService {

    @Autowired
    Inspector inspector;

    @Autowired
    private ReportDao reportDao;

    @Autowired
    private TechnologyService technologyService;
    @Autowired
    private ParameterService parameterService;

    @Transactional
    @Override
    public ReportVo inspect(ReportVo reportVo,InspectParameter inspectParameter) throws IOException {
        //统计文件后缀数量
        Map<String, LanguageEnum> suffixLanguageMapping = new HashMap<>();
        suffixLanguageMapping.put("java", LanguageEnum.JAVA);
        suffixLanguageMapping.put("aspx", LanguageEnum.C);
        suffixLanguageMapping.put("cs", LanguageEnum.C);
        suffixLanguageMapping.put("resx", LanguageEnum.C);
        suffixLanguageMapping.put("vue", LanguageEnum.JAVASCRIPT);
        suffixLanguageMapping.put("cpp", LanguageEnum.C);
        suffixLanguageMapping.put("py", LanguageEnum.PYTHON);
        suffixLanguageMapping.put("jsp", LanguageEnum.JSP);
        suffixLanguageMapping.put("go", LanguageEnum.GO);
        suffixLanguageMapping.put("js", LanguageEnum.JAVASCRIPT);
        suffixLanguageMapping.put("html", LanguageEnum.HTML);
        suffixLanguageMapping.put("php",LanguageEnum.PHP);
        suffixLanguageMapping.put("vbp",LanguageEnum.VB);
        suffixLanguageMapping.put("rs",LanguageEnum.RUST);
        suffixLanguageMapping.put("dpr",LanguageEnum.DELPHI);

        //构造成员变量
        inspector.setInspectParameter(inspectParameter);
        //构造报告vo
        inspector.setReport(reportVo);
        //需要重构
        inspector.setSuffixLanguageMapping(suffixLanguageMapping);
        ReportVo reportVoReturn = inspector.inspect();
        return reportVoReturn;
    }

    /**
     * 处理数据
     * @return
     * count 总共的关键技术
     * notSupport 不支持的关键技术数量
     */
    @Override
    public String freemakerData(ReportVo inspect, int count, int notSupport) {
        try {
        Map map = new HashMap();
        map.put("inspect", inspect);
        map.put("time", TimeUtil.getTime());
        HashMap<String, List<Warn>> warnMap = inspect.getWarnDetails();
        List<Technology> technologies = technologyService.findAllTechnology();
        Map techMap = new HashMap();
        for (Technology technology : technologies) {
            techMap.put(technology.getTechnologyName(), technology.getSupport());
        }
        map.put("techMap", techMap);
        map.put("count",count);
        map.put("notSupport",notSupport);
        map.put("warnMap", warnMap);
        map.put("technologies", technologies);

            String template = FreemarkerUtils.getTemplate("pg.ftl", map);
            String s = generateHtml(template, map);
            String filePath = FileUtil.createFilePath();
            FileUtil.write(s,"/opt/inspect/freemaker/"+filePath+"/"+inspect.getProjectName()+".html");
            String fn="/freemaker/"+filePath+"/"+inspect.getProjectName()+".html";
            return fn;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
    //执行静态化
    @Override
    public String generateHtml(String templateContent,Map model ){

        //创建配置对象
        Configuration configuration = new Configuration(Configuration.getVersion());
        //创建模板加载器
        StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
        stringTemplateLoader.putTemplate("template",templateContent);
        //向configuration配置模板加载器
        configuration.setTemplateLoader(stringTemplateLoader);
        //获取模板
        try {
            Template template = configuration.getTemplate("template");
            //调用api进行静态化
            String content = FreeMarkerTemplateUtils.processTemplateIntoString(template, model);
            return content;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }


}
