package com.zjty.inspect.service.impl;

import com.zjty.inspect.dao.TechnologyDao;
import com.zjty.inspect.entity.*;
import com.zjty.inspect.service.ReportService;
import com.zjty.inspect.utils.RedisUtil;
import freemarker.cache.StringTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

import java.util.Map;

/**
 * @author Mcj
 * @date 2020-02-27 10:35
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class ReportServiceImpl implements ReportService {

    @Autowired
    private TechnologyDao technologyDao;
    @Autowired
    private RedisUtil redisUtil;


    public ReportVo set(Report report){

        return new ReportVo();
    }

    //执行静态化
    private String generateHtml(String templateContent, Map model ){
        //创建配置对象
        Configuration configuration = new Configuration(Configuration.getVersion());
        //创建模板加载器
        StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
        stringTemplateLoader.putTemplate("template",templateContent);
        //向configuration配置模板加载器
        configuration.setTemplateLoader(stringTemplateLoader);
        //获取模板
        try {
            Template template = configuration.getTemplate("template");
            //调用api进行静态化
            String content = FreeMarkerTemplateUtils.processTemplateIntoString(template, model);
            return content;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }


}
