package com.zjty.inspect.config;

import com.zjty.inspect.aop.AopIntercept;
import com.zjty.inspect.entity.ServerResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Objects;

/**
 * @author Mcj
 * @date 2020-04-02 14:42
 */
@Configuration
public class LoginInterceptor implements HandlerInterceptor {

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private AopIntercept aopIntercept;
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) {
        String sessionId = request.getHeader("session");
        String url = "http://120.55.57.35:12345/user/getLogin/"+sessionId;
        ServerResponse user = restTemplate.getForObject(url, ServerResponse.class);
        if(Objects.requireNonNull(user).getData()==null){
            //不符合条件的给出提示信息，并转发到登录页面
            response.setStatus(403);
            return false;
        }
        aopIntercept.setUser(user.getData());
        return true;
    }

    @Bean
    public RestTemplate restTemplate(){
        return new RestTemplate();
    }
}
