package com.zjty.inspect.aop;

import com.zjty.inspect.entity.ServerResponse;
import com.zjty.inspect.entity.User;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

/**
 * @author Mcj
 * @date 2020-04-02 13:49
 */

@Aspect
@Slf4j
@Component
public class AopIntercept {

    @Autowired
    private RestTemplate restTemplate;

    @Pointcut("@annotation(com.zjty.inspect.aop.AuthAnnotation)")
    public void doPointCut() {
    }

    @Value("${address}")
    private String address;

    @Around("doPointCut()")
    public Object aroundMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String sessionId = request.getHeader("session");
        String url = "http://"+address+":12345/user/getLogin/"+sessionId;
        ServerResponse serverResponse = restTemplate.getForObject(url, ServerResponse.class);
        if(serverResponse!=null && serverResponse.getCode()!=200){
            ResponseEntity.status(403).body(1);
        }
        User user = serverResponse.getData();
        AuthAnnotation authAnnotation = ((MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(AuthAnnotation.class);
        String[] code = authAnnotation.code();
        if(user!=null){
            List<String> authorityCode = user.getAuthorityCode();
            for (String s : code) {
                if (authorityCode.contains(s)) {
                    long startMillis = System.currentTimeMillis();
                    Object proceed = joinPoint.proceed();
                    long endMillis = System.currentTimeMillis();
                    long time = (endMillis - startMillis);
                    log.info("评估总耗时{}毫秒", time);
                    log.info("PersonAspect2 ==> before method : {}", joinPoint.getSignature().getName());
                    log.info("注解的类型名称为{}", joinPoint.getSignature().getDeclaringTypeName());
                    log.info("方法修饰符个数为{}", joinPoint.getSignature().getModifiers());
                    log.info("方法名称为{}", joinPoint.getSignature().getName());
                    log.info("方法参数{}", joinPoint.getArgs());
                    return proceed;
                }
            }
        }
        return ResponseEntity.status(403).body("f");
    }

}
