package com.zjty.inspect.utils;

import com.alibaba.fastjson.JSON;
import com.zjty.inspect.entity.*;
import com.zjty.inspect.enums.*;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author Mcj
 * @date 2020-04-17 09:58
 */

public class WpsUtil {

    public static Map<String,String> createWps(Evaluation evaluation) {
        HashMap<String,List<TechnologyContent>> teMap=new HashMap<>();
        Reform reform = JSON.parseObject(evaluation.getInEva(), Reform.class);
        AssessmentReport assessmentReport = JSON.parseObject(evaluation.getOutEva(), AssessmentReport.class);
        HashMap<String, String> keyValue = new HashMap<>();
        keyValue.put("username",reform.getUsername());
        keyValue.put("mode",getMode(reform.getMode()));
        keyValue.put("projectName",reform.getProjectName());
        keyValue.put("codeUrl",reform.getCodeUrl());
        keyValue.put("codeName",reform.getCodeName());
        keyValue.put("gitUrl",reform.getGitUrl());
        keyValue.put("moduleNum",String.valueOf(reform.getModuleNum()));
        keyValue.put("cost",String.valueOf(reform.getCost()));
        keyValue.put("address",flipYesOrNo(reform.getAddress()));
        keyValue.put("localContact",reform.getLocalContact());
        keyValue.put("localPhone",reform.getLocalPhone());
        keyValue.put("secret",flipYesOrNo(reform.getSecret()));
        keyValue.put("disasterTolerance",flipYesOrNo(reform.getDisasterTolerance()));
        keyValue.put("safe",flipSafeStrong(reform.getSafe()));
        keyValue.put("framework",Framework.getByCode(reform.getFramework()).getName());
        for (int i = 0; i < reform.getApplicationType().size(); i++) {
            Integer code = reform.getApplicationType().get(i);
            keyValue.put("applicationType"+i+1,ApplicationType.getByCode(code).getName());
        }
        keyValue.put("time",String.valueOf(reform.getTime()));
        keyValue.put("tableNum",String.valueOf(reform.getTableNum()));
        keyValue.put("databaseNum",String.valueOf(reform.getDatabaseNum()));
        keyValue.put("strategy",strategyToString(reform.getStrategy()));
        keyValue.put("rto", RtoEnum.getByCode(reform.getRto()).getName());
        keyValue.put("rpo", RpoEnum.getByCode(reform.getRpo()).getName());
        keyValue.put("unitName",reform.getUnitName());
        keyValue.put("unitPhone",reform.getUnitPhone());
        keyValue.put("unitContent",reform.getUnitContent());
        keyValue.put("gradeProtection",flipYesOrNo(reform.getGradeProtection()));
        keyValue.put("cycle",String.valueOf(reform.getCycle()));
        SystemStructure systemStructure = reform.getSystemStructure();
        Details application = systemStructure.getApplication();
        getSys("application",application,keyValue);
        Details database = systemStructure.getDatabase();
        getSys("database",database,keyValue);

        Details nas = systemStructure.getNas();
        getSys("nas",nas,keyValue);

        Details slb = systemStructure.getSlb();
        getSys("slb",slb,keyValue);

        Details cdn = systemStructure.getCdn();
        getSys("cdn",cdn,keyValue);

        Details vps = systemStructure.getVps();
        getSys("vps",vps,keyValue);

        Browser browser = reform.getBrowser();
        List<BaseDes> compatibleBrowsers = browser.getCompatibleBrowsers();
        for (int i = 0; i < compatibleBrowsers.size(); i++) {
            int i1 = i + 1;
            keyValue.put("compatibleBrowsers"+i1, compatibleBrowsers.get(i).getName());
        }

        List<BaseDes> browserPlugs = browser.getBrowserPlugs();
        for (int i = 0; i < browserPlugs.size(); i++) {
            keyValue.put("browserPlugs"+i+1, browserPlugs.get(i).getName());
        }

        Middleware middleware = reform.getMiddleware();
        for (int i = 0; i < middleware.getMiddlewareEnums().size(); i++) {
            int i1 = i + 1;
            keyValue.put("middleware"+i1, middleware.getMiddlewareEnums().get(i).getName());
        }
        List<OtherApi> otherApis = middleware.getOtherApis();
        for (int i = 0; i < otherApis.size(); i++) {
            int i1 = i + 1;
            keyValue.put("otherApi"+i1, otherApis.get(i).getApiName());
        }
        for (int i = 0; i < middleware.getMicroServices().size(); i++) {
            int i1 = i + 1;
            keyValue.put("microService"+i1, middleware.getMicroServices().get(i).getName());
        }
        Database database1 = reform.getDatabase();
        for (int i = 0; i < database1.getDatabaseType().size(); i++) {
            int i1 = i + 1;
            keyValue.put("database"+i1, database1.getDatabaseType().get(i).getName());
        }
        keyValue.put("databaseView", flipYesOrNo(database1.getView()));
        keyValue.put("databaseStorage", flipYesOrNo(database1.getStorage()));
        keyValue.put("databaseFunction", flipYesOrNo(database1.getFunction()));
        keyValue.put("databaseDbLink", flipYesOrNo(database1.getDbLink()));
        keyValue.put("databaseTimeTask", flipYesOrNo(database1.getTimeTask()));
        keyValue.put("databaseSequence", flipYesOrNo(database1.getSequence()));
        keyValue.put("databaseTrigger", flipYesOrNo(database1.getTrigger()));
        keyValue.put("databaseSafe", flipYesOrNo(database1.getSafe()));
        keyValue.put("databaseDisasterTolerance", flipYesOrNo(database1.getDisasterTolerance()));
        keyValue.put("databaseSeparate", flipYesOrNo(database1.getSeparate()));
        keyValue.put("databasePerformance", flipYesOrNo(database1.getPerformance()));
        keyValue.put("databaseOtherContent",database1.getOtherContent());

        Apply apply = reform.getApply();
        keyValue.put("applyCost",String.valueOf(apply.getCost()));
        keyValue.put("applyReason",apply.getReason());

        DevelopLanguageSystem developLanguageSystem = reform.getDevelopLanguageSystem();
        keyValue.put("language",developLanguageSystem.getName());
        for (int i = 0; i < developLanguageSystem.getDevFrameworks().size(); i++) {
            int i1 = i + 1;
            keyValue.put("devFrameworks"+i1, developLanguageSystem.getDevFrameworks().get(i).getName());
        }
        for (int i = 0; i < developLanguageSystem.getFontDevTechnologies().size(); i++) {
            int i1 = i + 1;
            keyValue.put("fontDevTechnologies"+i1, developLanguageSystem.getFontDevTechnologies().get(i).getName());
        }
        for (int i = 0; i < developLanguageSystem.getCsDevTechnologies().size(); i++) {
            int i1 = i + 1;
            keyValue.put("csDevTechnologies"+i1, developLanguageSystem.getCsDevTechnologies().get(i).getName());
        }
        for (int i = 0; i < developLanguageSystem.getOpGAs().size(); i++) {
            int i1 = i + 1;
            keyValue.put("opGAs"+i1, developLanguageSystem.getOpGAs().get(i).getName());
        }
        for (int i = 0; i < developLanguageSystem.getDevLanguages().size(); i++) {
            int i1 = i + 1;
            keyValue.put("devLanguages"+i1, developLanguageSystem.getDevLanguages().get(i).getName());
        }

        LocalSystemDep localSystemDep = reform.getLocalSystemDep();
        keyValue.put("localSystemDepName", localSystemDep.getName());
        keyValue.put("localSystemDepMoney", String.valueOf(localSystemDep.getMoney()));
        keyValue.put("localSystemDepDes", localSystemDep.getDes());

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = simpleDateFormat.format(assessmentReport.getTime());
        keyValue.put("inspectTime", format);
        keyValue.put("createTime", System.currentTimeMillis()+"");
        keyValue.put("difficulty",String.valueOf(assessmentReport.getDifficulty()));
        keyValue.put("budget",assessmentReport.getBudget());

        SysScale sysScale = assessmentReport.getSysScale();
        keyValue.put("sysScaleCodeNum",sysScale.getCode().getNum().toString());
        keyValue.put("sysScaleCodeDes",sysScale.getCode().getDes());

        keyValue.put("sysScaleFileNum",sysScale.getFile().getNum().toString());
        keyValue.put("sysScaleFileDes",sysScale.getFile().getDes());

        keyValue.put("sysScaleModeNum",sysScale.getMode().getNum().toString());
        keyValue.put("sysScaleModeDes",sysScale.getMode().getDes());

        TechnologyList technologyList = assessmentReport.getTechnologyList();
        keyValue.put("technologyDes",technologyList.getDes());
        List<TechnologyReport> technologyReports = technologyList.getTechnologyReports();
        for (int i = 0; i < technologyList.getTechnologyReports().size(); i++) {
            int i2 = i + 1;
            keyValue.put("technology"+i2, technologyReports.get(i).getTechnology());
            for (int i1 = 0; i1 < technologyReports.get(i).getTechnologyContents().size(); i1++) {
                int i3 = i1 + 1;
                TechnologyContent technologyContent = technologyReports.get(i).getTechnologyContents().get(i1);
                keyValue.put("technologyContentLocal"+i2+"-"+i3, technologyContent.getLocal());
                keyValue.put("technologyContentKeyWord"+i2+"-"+i3, technologyContent.getKeyWord());
                keyValue.put("technologyContentFile"+i2+"-"+i3, technologyContent.getFile());
                keyValue.put("technologyContentPosition"+i2+"-"+i3, technologyContent.getPosition());
                keyValue.put("technologyContentStrategy"+i2+"-"+i3, getMode(technologyContent.getStrategy()));
            }
        }
        for (TechnologyReport technologyReport : technologyReports) {
           teMap.put(technologyReport.getTechnology(),technologyReport.getTechnologyContents());
        }
        Set<String> strings = teMap.keySet();

        StringBuilder youhua=new StringBuilder();
        StringBuilder xiugai=new StringBuilder();
        StringBuilder weizhi=new StringBuilder();
        for (String string : strings) {
            if(string.contains("优化")){
                List<TechnologyContent> technologyContents = teMap.get(string);
                String str = DocumentWordUtil.getTableString(technologyContents, string, "优化");
                youhua.append(str);
            }else if(string.contains("不支持")){
                List<TechnologyContent> technologyContents = teMap.get(string);
                String str = DocumentWordUtil.getTableString(technologyContents, string, "重新开发");
                xiugai.append(str);
            }else if(string.contains("未知")){
                List<TechnologyContent> technologyContents = teMap.get(string);
                String str = DocumentWordUtil.getTableString(technologyContents, string, "验证修改或重新开发");
                weizhi.append(str);
            }
        }
        keyValue.put("teyouhua",youhua.toString());
        keyValue.put("texiugai",xiugai.toString());
        keyValue.put("teweizhi",weizhi.toString());
        Workload workload = assessmentReport.getWorkload();
        keyValue.put("workloadDes",workload.getDes());
        keyValue.put("workloadCost",String.valueOf(workload.getCost()));
        keyValue.put("workloadMode",String.valueOf(workload.getMode()));

        Basis development = workload.getDevelopment();
        keyValue.put("workloadDevelopmentVolume",String.valueOf(development.getDevelopmentVolume()));
        keyValue.put("workloadDevelopmentCorrectionFactor",String.valueOf(development.getCorrectionFactor()));

        Basis test = workload.getTest();
        keyValue.put("workloadTestVolume",String.valueOf(test.getDevelopmentVolume()));
        keyValue.put("workloadTestCorrectionFactor",String.valueOf(test.getCorrectionFactor()));

        Basis deploy = workload.getDeploy();
        keyValue.put("workloadDeployVolume",String.valueOf(deploy.getDevelopmentVolume()));
        keyValue.put("workloadDeployCorrectionFactor",String.valueOf(deploy.getCorrectionFactor()));

        Basis total = workload.getTotal();
        keyValue.put("workloadTotalVolume",String.valueOf(total.getDevelopmentVolume()));
        keyValue.put("workloadTotalCorrectionFactor",String.valueOf(total.getCorrectionFactor()));

        DifficultyAssessment difficultyAssessment = assessmentReport.getDifficultyAssessment();
        keyValue.put("difficultyAssessmentDes",difficultyAssessment.getDes());
        FrameDifficulty frameDifficulty = difficultyAssessment.getFrameDifficulty();
        keyValue.put("difficultyDifficultySystemEvaluation",String.valueOf(frameDifficulty.getSystemEvaluation()));
        keyValue.put("difficultyDifficultyMessage",String.valueOf(frameDifficulty.getMessage()));
        keyValue.put("difficultyDifficultyDifficulty",String.valueOf(frameDifficulty.getDifficulty()));
        keyValue.put("difficultyDifficultyLoad",String.valueOf(frameDifficulty.getLoad()));
        keyValue.put("difficultyDifficultyDetails",Framework.getByCode(frameDifficulty.getDetails()).getName());
        keyValue.put("difficultyDifficultyDistributed",flipYesOrNo(frameDifficulty.getDistributed()));
        keyValue.put("difficultyDifficultyLoadBalance",flipYesOrNo(frameDifficulty.getLoadBalance()));
        keyValue.put("difficultyDifficultyDisaster",flipYesOrNo(frameDifficulty.getDisaster()));
        keyValue.put("difficultyDifficultyOtherDemand",frameDifficulty.getOtherDemand());

        BrowserDifficulty browserDifficulty = difficultyAssessment.getBrowserDifficulty();
        keyValue.put("browserDifficultySystemEvaluation",String.valueOf(browserDifficulty.getSystemEvaluation()));
        keyValue.put("browserDifficultyMessage",String.valueOf(browserDifficulty.getMessage()));
        keyValue.put("browserDifficultyDifficulty",String.valueOf(browserDifficulty.getDifficulty()));
        keyValue.put("browserDifficultyLoad",String.valueOf(browserDifficulty.getLoad()));
        keyValue.put("browserDifficultyStyle",flipYesOrNo(browserDifficulty.getStyle()));
        keyValue.put("browserDifficultyApi",flipYesOrNo(browserDifficulty.getApi()));
        keyValue.put("browserDifficultyPlugInUnit",flipYesOrNo(browserDifficulty.getPlugInUnit()));
        keyValue.put("browserDifficultyGeography",flipYesOrNo(browserDifficulty.getGeography()));
        keyValue.put("browserDifficultyPeripheral",flipYesOrNo(browserDifficulty.getPeripheral()));
        keyValue.put("browserDifficultyAnimation",flipYesOrNo(browserDifficulty.getAnimation()));
        keyValue.put("browserDifficultyThreeD",flipYesOrNo(browserDifficulty.getThreeD()));
        keyValue.put("browserDifficultyDocument",flipYesOrNo(browserDifficulty.getDocument()));
        keyValue.put("browserDifficultyMedia",flipYesOrNo(browserDifficulty.getMedia()));
        keyValue.put("browserDifficultyFlash",flipYesOrNo(browserDifficulty.getFlash()));
        keyValue.put("browserDifficultyOtherDemand",flipYesOrNo(browserDifficulty.getOtherDemand()));

        MiddlewareDifficulty middlewareDifficulty = difficultyAssessment.getMiddlewareDifficulty();
        keyValue.put("middlewareDifficultySystemEvaluation",String.valueOf(middlewareDifficulty.getSystemEvaluation()));
        keyValue.put("middlewareDifficultyMessage",String.valueOf(middlewareDifficulty.getMessage()));
        keyValue.put("middlewareDifficultyDifficulty",String.valueOf(middlewareDifficulty.getDifficulty()));
        keyValue.put("middlewareDifficultyLoad",String.valueOf(middlewareDifficulty.getLoad()));
        keyValue.put("middlewareDifficultyNumber",String.valueOf(middlewareDifficulty.getNumber()));
        keyValue.put("middlewareDifficultyWeb",flipYesOrNo(middlewareDifficulty.getWeb()));
        keyValue.put("middlewareDifficultyJndi",flipYesOrNo(middlewareDifficulty.getJndi()));
        keyValue.put("middlewareDifficultyJms",flipYesOrNo(middlewareDifficulty.getJms()));
        keyValue.put("middlewareDifficultyRoute",flipYesOrNo(middlewareDifficulty.getRoute()));

        DatabaseDifficulty databaseDifficulty = difficultyAssessment.getDatabaseDifficulty();
        keyValue.put("databaseDifficultyDifficulty",String.valueOf(databaseDifficulty.getDifficulty()));
        keyValue.put("databaseDifficultyLoad",String.valueOf(databaseDifficulty.getLoad()));
        keyValue.put("databaseDisasterTolerance",getDis(databaseDifficulty.getDisasterTolerance()));
        keyValue.put("databaseDifficultySafe",flipYesOrNo(databaseDifficulty.getSafe()));
        keyValue.put("databaseDifficultySeparate",flipYesOrNo(databaseDifficulty.getSeparate()));
        keyValue.put("databaseDifficultyPerformance",flipYesOrNo(databaseDifficulty.getPerformance()));

        ProgramDifficulty programDifficulty = difficultyAssessment.getProgramDifficulty();
        keyValue.put("programDifficultyDifficulty",String.valueOf(programDifficulty.getDifficulty()));
        keyValue.put("programDifficultyLoad",String.valueOf(programDifficulty.getLoad()));
        FreeMakerUtils.parseTpl("报告模板",keyValue);
        return keyValue;
    }

    public static DocumentContent setDocumentTable(List<String> data,int col){
//        String tableString = DocumentWordUtil.getTableString(data, col);
//        DocumentContent documentContent = new DocumentContent();
//        设置进head标题下面的表格中
//        documentContent.setDocumentTable(tableString);
        return null;
    }
    public static List<DocumentContent> setDocumentContents(DocumentContent documentContent){
        ArrayList<DocumentContent> documentContents = new ArrayList<>();
        documentContents.add(documentContent);
        return documentContents;
    }

    private static int getFramework(String construction) {
        switch (construction) {
            case "B/S":
                return 1;
            case "C/S":
                return 2;
            case "单机运行":
                return 0;
            case "分布式":
                return 4;
        }
        return -1;
    }
    private static String getFilpFramework(int construction) {
        switch (construction) {
            case 1:
                return "B/S";
            case 2:
                return "C/S";
            case 0:
                return "单机运行";
            case 4:
                return "分布式";
            default:
                break;
        }
        return "";
    }

    private static int yesOrNo(String target) {
        if ("是".equals(target)) {
            return 1;
        } else if ("否".equals(target)) {
            return 2;
        } else {
            return -1;
        }
    }
    private static int SpecialYesOrNo(String target) {
        if ("是".equals(target)) {
            return 4;
        } else if ("否".equals(target)) {
            return 0;
        } else {
            return -1;
        }
    }
    private static String flipYesOrNo(Integer target) {
        if (target == 1) {
            return "是";
        } else if (target == 2) {
            return "否";
        } else {
            return "我不清楚";
        }
    }
    private static String flipSafeYesOrNo(Integer target) {
        if(target==null){
            return "否";
        }
        if (target == 4) {
            return "强";
        } else if (target == 2) {
            return "弱";
        } else {
            return "我不清楚";
        }
    }
    private static String flipSpecialYesOrNo(Integer target) {
        if (target == 4) {
            return "是";
        } else if (target == 0) {
            return "否";
        } else {
            return "我不清楚";
        }
    }

    private static String getMode(Integer target) {
        if(target==null){
            return "我不清楚";
        }
        if (target == 1) {
            return "改造";
        } else if (target == 2) {
            return "适配";
        } else {
            return "我不清楚";
        }
    }

    private static String flipSafeStrong(Integer target) {
        if(target==null || target==1){
            return "无";
        }
        if (target == 3) {
            return "强";
        } else if (target == 2) {
            return "弱";
        } else {
            return "我不清楚";
        }
    }
    private static String strategyToString(Integer target){
        if(target == 1){
            return "休息日或晚间切换";
        }else if(target == 2){
            return "暂停服务";
        }else if(target == 3){
            return "平滑过渡";
        }else{
            return "不清楚";
        }
    }

    private static String localOrCloud(Integer deploy){
        if(deploy==1){
            return "本地";
        }else if(deploy==2){
            return "政务云";
        }else{
            return "不清楚";
        }
    }
    private static String getDis(Integer dis){
        if(dis==1){
            return "否";
        }else if(dis==2){
            return "主备";
        }else if(dis==3){
            return "分布式";
        }else{
            return "不清楚";
        }
    }
    private static void getSys(String sysName,Details application, Map<String,String> keyValue){
        keyValue.put(sysName+"Deploy",localOrCloud(application.getDeploy()));
        keyValue.put(sysName+"OperateSystem",application.getOperateSystem().getName());
        keyValue.put(sysName+"Code",String.valueOf(application.getOperateSystem().getCode()));
        keyValue.put(sysName+"Num",application.getNum());
        keyValue.put(sysName+"CpuNum",application.getCpuNum());
        keyValue.put(sysName+"Ghz",application.getGhz());
        keyValue.put(sysName+"Space",application.getSpace());
        keyValue.put(sysName+"Other",application.getSpace());
        keyValue.put(sysName+"Edition",application.getEdition());
        keyValue.put(sysName+"Memory",application.getMemory());
    }
}
