package com.zjty.inspect.service.impl;

import com.zjty.inspect.dao.ReportDao;
import com.zjty.inspect.entity.*;
import com.zjty.inspect.enums.Language;
import com.zjty.inspect.service.InspectService;
import com.zjty.inspect.inspect.Inspector;
import com.zjty.inspect.service.ParameterService;
import com.zjty.inspect.service.TechnologyService;
import com.zjty.inspect.utils.FileUtil;
import com.zjty.inspect.utils.FreemarkerUtils;
import com.zjty.inspect.utils.RandomUtil;
import com.zjty.inspect.utils.TimeUtil;
import freemarker.cache.StringTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 解析
 * @author mcj
 */
@Service
public class InspectServiceImpl implements InspectService {

    @Autowired
    Inspector inspector;

    @Autowired
    private ReportDao reportDao;

    @Autowired
    private TechnologyService technologyService;
    @Autowired
    private ParameterService parameterService;

    @Transactional
    @Override
    public ReportVo inspect(ReportVo reportVo,InspectParameter inspectParameter) {
        //统计文件后缀数量
        Map<String, Language> suffixLanguageMapping = new HashMap<>();
        suffixLanguageMapping.put("java", Language.JAVA);
        suffixLanguageMapping.put("aspx", Language.C井);
        suffixLanguageMapping.put("cs", Language.C井);
        suffixLanguageMapping.put("resx", Language.C井);
        suffixLanguageMapping.put("vue", Language.JAVASCRIPT);
        suffixLanguageMapping.put("cpp", Language.C);
        suffixLanguageMapping.put("py", Language.PYTHON);
        suffixLanguageMapping.put("jsp", Language.JAVA);
        suffixLanguageMapping.put("go", Language.GO);
        suffixLanguageMapping.put("js", Language.JAVASCRIPT);
        suffixLanguageMapping.put("html", Language.HTML);
        //构造成员变量
        inspector.setInspectParameter(inspectParameter);
        //构造报告vo
        inspector.setReport(reportVo);
        //需要重构
        inspector.setSuffixLanguageMapping(suffixLanguageMapping);
        ReportVo reportVoReturn = inspector.inspect();
        return reportVoReturn;
    }

    /**
     * 处理数据
     * @return
     * count 总共的关键技术
     * notSupport 不支持的关键技术数量
     */
    @Override
    public String freemakerData(ReportVo inspect, int count, int notSupport) {
        try {
        Map map = new HashMap();
        map.put("inspect", inspect);
        map.put("time", TimeUtil.getTime());
        HashMap<String, List<Warn>> warnMap = inspect.getWarnDetails();
        List<Technology> technologies = technologyService.findAllTechnology();
        Map techMap = new HashMap();
        for (Technology technology : technologies) {
            techMap.put(technology.getTechnologyName(), technology.getSupport());
        }
        map.put("techMap", techMap);
        map.put("count",count);
        map.put("notSupport",notSupport);
        map.put("warnMap", warnMap);
        map.put("technologies", technologies);

            String template = FreemarkerUtils.getTemplate("pg.ftl", map);
            String s = generateHtml(template, map);
            String filePath = FileUtil.createFilePath();
            FileUtil.write(s,"/opt/inspect/freemaker/"+filePath+"/"+inspect.getProjectName()+".html");
            String fn="/freemaker/"+filePath+"/"+inspect.getProjectName()+".html";
            return fn;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
    //执行静态化
    public String generateHtml(String templateContent,Map model ){

        //创建配置对象
        Configuration configuration = new Configuration(Configuration.getVersion());
        //创建模板加载器
        StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
        stringTemplateLoader.putTemplate("template",templateContent);
        //向configuration配置模板加载器
        configuration.setTemplateLoader(stringTemplateLoader);
        //获取模板
        try {
            Template template = configuration.getTemplate("template");
            //调用api进行静态化
            String content = FreeMarkerTemplateUtils.processTemplateIntoString(template, model);
            return content;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }


}
