package com.zjty.inspect.controller;

import com.zjty.inspect.entity.InspectParameter;
import com.zjty.inspect.entity.ReportVo;
import com.zjty.inspect.service.InspectService;
import com.zjty.inspect.utils.FileUtil;
import com.zjty.inspect.utils.GitLabUtil;
import com.zjty.inspect.utils.MavenUtil;
import com.zjty.inspect.utils.UUIDUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.io.FileUtils;
import org.apache.tomcat.util.http.fileupload.disk.DiskFileItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import java.io.*;

/**
 * 评估接口
 * @author mcj
 */
@RestController
@RequestMapping("/inspect")
@Api(value = "cms页面管理接口",description = "cms页面管理接口,提供页面的增、删、改、查")
public class InspectController {
    @Autowired
    private InspectService inspectService;


    /**
     * 上传代码进行评估
     * @param years
     * @param systemFund
     * @param modules
     * @param multfile
     * @return
     * @throws IOException
     */
    @PostMapping("/path")
    @ApiOperation("上传代码进行评估")
    public ResponseEntity inspect(Integer years,Integer systemFund,Integer modules
            ,String valid,Double framework,Double safety,Double disaster,Integer data
            ,Integer admin, MultipartFile multfile) throws IOException {

        File file = FileUtil.saveToLocal(multfile);
        InspectParameter inspectParameter = new InspectParameter();
        inspectParameter.setSourceAddress(file.getPath());
        inspectParameter.setSystemFund(systemFund);
        inspectParameter.setAdmin(admin);
        inspectParameter.setModules(modules);
        inspectParameter.setSafety(safety);
        inspectParameter.setValid(valid);
        inspectParameter.setYears(years);
        inspectParameter.setDisaster(disaster);
        inspectParameter.setData(data);
        inspectParameter.setFramework(framework);
        inspectParameter.setPath(file.getCanonicalPath());
        inspectParameter.setId(UUIDUtil.getUUID());
        ReportVo reportVo = new ReportVo();
        reportVo.setSourceAddress(file.getCanonicalPath());
        ReportVo inspect = inspectService.inspect(reportVo,inspectParameter);
        return ResponseEntity.ok(inspect);
    }

    /**
     * git下载代码进行评估
     * @param inspectParameter 封装
     * @return
     */
    @PostMapping("/git")
    @ApiOperation("git下载代码进行评估")
    public ResponseEntity inspect1(@RequestBody InspectParameter inspectParameter){
        String path = GitLabUtil.downLoadProject(inspectParameter.getGitAddress(),inspectParameter.getGitName());
        inspectParameter.setId(UUIDUtil.getUUID());
        ReportVo report1 = new ReportVo();
        report1.setSourceAddress(path);
        inspectService.inspect(report1,inspectParameter);
        return ResponseEntity.ok(200);
    }

    @PostMapping("/frontend")
    @ApiOperation("git下载代码进行评估")
    public ResponseEntity inspect(MultipartFile file) throws IOException {

        return ResponseEntity.ok(200);
    }

}
