package com.zjty.inspect.utils;

import com.zjty.inspect.entity.*;
import com.zjty.inspect.entity.Properties;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;
import java.nio.charset.MalformedInputException;
import java.nio.file.*;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.*;

/**
 * 项目体检，根据既定特征值，
 * 扫描、统计、分析项目特征，
 * 生成报告VO
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Inspector {

//    public static void main(String[] args) {
//
//
//        //Project project = new Project();
//
//        Map<String, Report.Language> suffixLanguageMapping = new HashMap<>();
//        suffixLanguageMapping.put("java", Report.Language.JAVA);
//        suffixLanguageMapping.put("cpp", Report.Language.CPP);
//        suffixLanguageMapping.put("vue", Report.Language.VUE);
//        suffixLanguageMapping.put("py", Report.Language.PYTHON);
//        suffixLanguageMapping.put("jsp", Report.Language.JSP);
//        suffixLanguageMapping.put("html", Report.Language.ONLYVIEW);
//        suffixLanguageMapping.put("js", Report.Language.JAVASCRIPT);
//        suffixLanguageMapping.put("go", Report.Language.GO);
//
//        List<Rule> ruleList = new ArrayList<>();
//        //com.mysql.cj.jdbc.Driver//com.mysql.jdbc.Driver
//        ruleList.add(new Rule("com.mysql.cj.jdbc.Driver", "建议修改为postgresql数据库驱动"));
//        ruleList.add(new Rule("com.mysql.jdbc.Driver", "建议修改为postgresql数据库驱动"));
//
//
//        //net.sourceforge.jtds.jdbc.Driver//sqlserver
//        ruleList.add(new Rule("net.sourceforge.jtds.jdbc.Driver", "建议修改为postgresql数据库驱动"));
//        //COM.ibm.db2.jdbc.app.DB2Driver//com.ibm.db2.jcc.DB2Driver//COM.ibm.db2.jdbc.net.DB2Driver//com.ibm.db2.jcc.DB2Driver
//        ruleList.add(new Rule("DB2Driver", "建议修改为postgresql数据库驱动"));
//        //oracle.jdbc.OracleDriver//oracle.jdbc.driver.OracleDriver
//        ruleList.add(new Rule("OracleDriver", "建议修改为postgresql数据库驱动"));
//
//        ruleList.add(new Rule("mysql-connector-java", "建议修改为postgresql依赖声明"));
//        ruleList.add(new Rule("com.microsoft.sqlserver", "建议修改为postgresql依赖声明"));
//        ruleList.add(new Rule("com.oracle", "建议修改为postgresql依赖声明"));
//        ruleList.add(new Rule("org.mariadb.jdbc", "建议修改为postgresql依赖声明"));
//        ruleList.add(new Rule("com.sap.cloud.db.jdbc", "建议修改为postgresql依赖声明"));
//        ruleList.add(new Rule("com.ibm.informix", "建议修改为postgresql依赖声明"));
//        ruleList.add(new Rule("org.firebirdsql.jdbc", "建议修改为postgresql依赖声明"));
//        ruleList.add(new Rule("org.hsqldb", "建议修改为postgresql依赖声明"));
//        ruleList.add(new Rule("com.h2database", "建议修改为postgresql依赖声明"));
//        ruleList.add(new Rule("org.apache.derby", "建议修改为postgresql依赖声明"));
//        ruleList.add(new Rule("org.mongodb", "建议修改为postgresql依赖声明"));
//
//        ruleList.add(new Rule("public native", "这里用到了JNI"));
//        ruleList.add(new Rule("<packaging>jar</packaging>", "建议修改打包方式为war包并排除掉springboot内置的tomcat,以部署到国产化中间件上"));
//        ruleList.add(new Rule("WebOffice", "这里用到了weboffice文档展示编辑插件"));
//        ruleList.add(new Rule("webOffice", "这里用到了weboffice文档展示编辑插件"));
//        ruleList.add(new Rule("weboffice", "这里用到了weboffice文档展示编辑插件"));
//        ruleList.add(new Rule("Weboffice", "这里用到了weboffice文档展示编辑插件"));
//        ruleList.add(new Rule("pdfobject.min.js", "这里用到了pdf文档展示插件"));
//        ruleList.add(new Rule("pdfobject.js", "这里用到了pdf文档展示插件"));
//        ruleList.add(new Rule(".swf", "这里用到了flash流媒体播放插件"));
//
//        String path = Inspector.class.getProtectionDomain().getCodeSource().getLocation().getFile();
//        String decode = null;
//        try {
//            decode = URLDecoder.decode(path, "UTF-8");
//        } catch (UnsupportedEncodingException e) {
//            e.printStackTrace();
//        }
//        File outfile = new File(decode);
//
//        int i = 0;
//        System.out.println("请输入文件夹路径，该文件夹中包含多个项目");
//        Scanner scanner = new Scanner(System.in);
//        String line = scanner.nextLine();
//        File file = new File(line);
//        File[] files = file.listFiles();
//        for (File file1 : files) {
//            Report report = new Inspector(file1.getPath(), suffixLanguageMapping, ruleList).inspect();
//
//            File file2 = new File(outfile.getParent() + "/评估报告" + i++ + ".txt");
//            if (file2.exists()) {
//                file2.delete();
//            }
//            try {
//                System.out.println("生成报告文件" + file2.getAbsolutePath());
//                file2.createNewFile();
//                FileWriter writer = new FileWriter(file2);
//                writer.write("系统名称：" + file1.getName() + "\n");
//                writer.write("评估时间：" + new Date() + "\n\n");
//                writer.write("语言：" + report.getLanguage() + "\t");
//                writer.write("依赖管理工具：" + report.getDependenceManagement() + "\t");
//                writer.write("是否前后端分离：" + report.getIsSeparate() + "\t");
//                writer.write("架构：" + report.getFramework() + "\n");
//                writer.write("数据库类型：" + report.getDatabaseType() + "\t");
//                writer.write("文件数量：" + report.getFileNum() + "\t");
//                writer.write("代码行数：" + report.getLineNum() + "\n\n");
//
//                writer.write("后端依赖列表：\n");
//                for (PomDependency dependency : report.getBackend()) {
//
//                    writer.write("" + dependency.getGroupId() + "\t" + dependency.getArtifactId() + "\t" + dependency.getVersion() + "\n");
//                }
//                writer.write("\n前端依赖列表：\n");
//                for (PomDependency dependency : report.getFrontend()) {
//                    writer.write("" + dependency.getGroupId() + "\t" + dependency.getArtifactId() + "\t" + dependency.getVersion() + "\n");
//                }
//
//                int j = 1;
//                for (Warn warn : report.getWarnList()) {
//                    writer.write(j++ + "、所在文件：" + warn.getPath() + " 行数:" + warn.getLine() + "行 关键字:" + warn.getKeyWord() + "\n"
//                            + "建议：" + warn.getSuggest());
//                }
//                writer.close();
//            } catch (IOException e) {
//                e.printStackTrace();
//            }
//        }
//
//    }

    private Report report;
    private Map<String, Counter> languageMatchMap;
    private Map<String, Report.Language> suffixLanguageMapping;
    private String path;
    private List<Rule> ruleList;

    private Map<String, List<Path>> configFileTypePathsMapping;
    private List<Warn> warnList;

    private List<PomDependency> jarFiles;
    private List<PomDependency> jsFiles;
    private HashMap<String,String> versionMap = new HashMap<>();

    public Inspector(String path, Map<String, Report.Language> suffixLanguageMapping, List<Rule> ruleList) {
        this.path = path;
        this.suffixLanguageMapping = suffixLanguageMapping;
        this.ruleList = ruleList;
        this.languageMatchMap = new HashMap<>();
        for (String s : suffixLanguageMapping.keySet()) {
            languageMatchMap.put(s, new Counter());
        }
        /**
         * 如果存在html文件，不一定是前端代码，
         * 如果只存在html文件，不存在其他类型文件，大概率是前端代码
         * 策略：
         *      先检测是否存在html文件，如果存在，假定为前端项目
         *      然后检测其他条件，如果符合，将假定冲掉
         */
        this.configFileTypePathsMapping = new HashMap<>();
        configFileTypePathsMapping.put("xml", new ArrayList<>());
        configFileTypePathsMapping.put("gradle", new ArrayList<>());
        configFileTypePathsMapping.put("properties", new ArrayList<>());
        configFileTypePathsMapping.put("yml", new ArrayList<>());
        this.jarFiles = new ArrayList<>();
        this.jsFiles = new ArrayList<>();
        this.report = new Report();
        this.warnList = new ArrayList<>();
    }

    int fileNum = 0;
    long lineNum = 0;

    /**
     * FileVisitResult.CONTINUE 继续遍历
     * FileVisitResult.TERMINATE 中止访问
     * FileVisitResult.SKIP_SIBLINGS 不访问同级的文件或目录
     * FileVisitResult.SKIP_SUBTREE 不访问子目录
     */
    public Report inspect() {
        try {
            FileSystem aDefault = FileSystems.getDefault();
            Map<String, PathMatcher> languageSuffixMatcherMapping = new HashMap<>();
            for (String s : suffixLanguageMapping.keySet()) {
                languageSuffixMatcherMapping.put(s, aDefault.getPathMatcher("glob:**/*." + s));
            }
            Map<PathMatcher, String> configFileMatcherSuffixMapping = new HashMap<>();
            for (String s : configFileTypePathsMapping.keySet()) {
                configFileMatcherSuffixMapping.put(aDefault.getPathMatcher("glob:**/*." + s), s);
            }
            /// TODO: 2020-02-12
            // WebSocketServer.sendIn(uuid,TimeUtil.getNowDate() + " 项目评估：" + "开始读取项目文件");
            Files.walkFileTree(Paths.get(path), new FileVisitor<Path>() {
                /**
                 * 统计某个后缀出现的次数
                 * @param dir
                 * @param attrs
                 * @return
                 * @throws IOException
                 */
                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    /**
                     * 这里是对于路径（文件夹）的过滤，在这里读不到文件
                     * 如果能判断，可以返回FileVisitResult.SKIP_SUBTREE 不访问子目录
                     */
                    //if(dir.getFileName().startsWith("."))return FileVisitResult.SKIP_SUBTREE;
                    //if (dir.endsWith(".git"))return FileVisitResult.SKIP_SUBTREE;
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    fileNum++;
                    for (Map.Entry<String, PathMatcher> entry : languageSuffixMatcherMapping.entrySet()) {
                        if (entry.getValue().matches(file)) {
                            languageMatchMap.get(entry.getKey()).plus();
                        }
                    }
                    for (Map.Entry<PathMatcher, String> entry : configFileMatcherSuffixMapping.entrySet()) {
                        if (entry.getKey().matches(file)) {
                            configFileTypePathsMapping.get(entry.getValue()).add(file);
                        }
                    }
                    if (file.toString().endsWith(".jar")) {
                        PomDependency pomDependency = new PomDependency();
                        report.setFramework("java");
                        String fileName = file.getFileName().toString();
                        String substring = fileName.substring(0, fileName.indexOf("."));
                        int i = substring.lastIndexOf("-");
                        pomDependency.setType(2);
                        if (i > -1) {
                            pomDependency.setArtifactId(substring.substring(0, i));
                            pomDependency.setVersion(substring.substring(i));
                        } else {
                            pomDependency.setArtifactId(substring);
                        }
                        jarFiles.add(pomDependency);
                    }
                    if (file.toString().endsWith(".js")) {
                        PomDependency pomDependency = new PomDependency();
                        report.setFramework("javascript");
                        String fileName = file.getFileName().toString();
                        int i = fileName.lastIndexOf(".");
                        int i1 = fileName.indexOf("-");
                        pomDependency.setType(1);
                        if (i1 > -1) {
                            pomDependency.setArtifactId(fileName.substring(0, i1));
                            pomDependency.setVersion(fileName.substring(i1 + 1, i));
                        } else {
                            pomDependency.setArtifactId(fileName.substring(0, fileName.indexOf(".")));
                        }
                        jsFiles.add(pomDependency);
                    }
                    List<String> allLines;
                    try {
                        allLines = Files.readAllLines(file);
                    } catch (MalformedInputException e) {
                        return FileVisitResult.CONTINUE;
                    }
                    lineNum += allLines.size();

                    //国产
                    for (int i = 0; i < allLines.size(); i++) {
                        String s = allLines.get(i);
                        for (Rule rule : ruleList) {
                            if (s.indexOf(rule.getTarget()) > -1) {
                                warnList.add(new Warn(file.toString(), i + 1, rule.getTarget(), rule.getAdvice()));
                            }
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
            //    WebSocketServer.sendIn(uuid,TimeUtil.getNowDate() + " 项目评估：" + "读取项目文件结束");
        } catch (IOException e) {
            e.printStackTrace();
        }
        return analysis();
    }

    //基本信息
    @Transactional
    public Report analysis() {
        report.setFileNum(fileNum);
        report.setLineNum(lineNum);
        //report.setLanguage(Report.Language.ONLYVIEW);
        Report.Language most = null;
        int maxnum = 0;
        for (Map.Entry<String, Counter> entry : languageMatchMap.entrySet()) {
            if (entry.getValue().getNumber() > maxnum) {
                most = suffixLanguageMapping.get(entry.getKey());

                maxnum = entry.getValue().getNumber();
            }
        }
        report.setLanguage(most == null ? Report.Language.UNKNOW : most);
        report.setFramework(most == null ? Report.Language.UNKNOW.name() : most.name());
        report.setBackend(jarFiles);
        report.setFrontend(jsFiles);
        report.setCreateTime(new Date());
        /**
         * 对于具体的配置文件对应的处理方法
         * 增加要处理的文件类型需要在这里增加相应的处理方法
         */
        //后端依赖
        ArrayList<PomDependency> backend = new ArrayList<>();
        //前端依赖
        ArrayList<PomDependency> frontend = new ArrayList<>();

        for (Map.Entry<String, List<Path>> entry : configFileTypePathsMapping.entrySet()) {
            //System.out.println(entry.getKey());
            switch (entry.getKey()) {
                /**
                 * 配置文件的一个类型，xml文件
                 */
                case "xml":
                    //System.out.println(entry.getValue().size());
                    for (Path path : entry.getValue()) {
                        /**
                         * 对于maven工程，可以在maven配置文件中得到一这些信息
                         *      编译方式打包方式和打好的包的路径
                         */
                        if (path.getFileName().endsWith("pom.xml")) {
                            report.setDependenceManagement(Report.DependenceManagement.MAVEN);
                            report.setCompileFilePath(path.toString());
                            //解析pom文件
                            ProjectPom projectPom = AnalysisFile.analysisPom(path);
                            //设置依赖
                            for (PomDependency dependency : projectPom.getDependencies()) {
                                dependency.setType(2);
                            }
                            for (Properties property : projectPom.getProperties()) {
                                versionMap.put(property.getName(),property.getValue());
                            }
                            jarFiles.addAll(projectPom.getDependencies());
                        }

                    }
                    break;
                /**
                 * properties文件
                 *
                 */
                case "gradle":
                    for (Path path : entry.getValue()) {
                        /**
                         * 对于maven工程，可以在maven配置文件中得到一这些信息
                         *      编译方式打包方式和打好的包的路径
                         */
                        if (path.getFileName().endsWith("build.gradle")) {
                            report.setDependenceManagement(Report.DependenceManagement.GRADLE);
                            report.setCompileFilePath(path.toString());
                            //解析pom文件
                            List<PomDependency> pomDependencies = AnalysisFile.analysisGradle(path);
                            //设置依赖
                            for (PomDependency dependency : pomDependencies) {
                                dependency.setType(2);
                            }
                            jarFiles.addAll(pomDependencies);
                        }
                    }
                case "json":
                    for (Path path : entry.getValue()) {
                        if ("package.json".equals(path.getFileName())) {
                            VueDep json = FileUtil.parseJsonFile(path.toString());
                            Map<String, String> dependencies = json.getDependencies();
                            for (String s : dependencies.keySet()) {
                                PomDependency pomDependency = new PomDependency();
                                pomDependency.setArtifactId(s);
                                pomDependency.setVersion(dependencies.get(s));
                                pomDependency.setType(1);
                                frontend.add(pomDependency);
                            }
                        }
                    }
                    break;
                default:
            }
        }

        if (report.getLanguage() == Report.Language.JAVA) {
            String tips = "该项目采用java语言开发，使用了主流框架，未见生僻插件，适配无明显难点。预计适配工作量较小，适配成功率高";
            // TODO: 2020-02-16 人工估计工作量，一天200行代码 
        }
        List<PomDependency> backend1 = report.getBackend();
        for (PomDependency pomDependency : backend1) {
            String version = pomDependency.getVersion();
            String versionString = version.replaceAll("\\$", "").replaceAll("\\{", "").replaceAll("}", "");
            if(versionMap.containsKey(versionString)){
                pomDependency.setVersion(versionMap.get(versionString));
            }
        }
        report.setWarnList(warnList);
        return report;
    }

    public class Counter {
        private int i = 0;

        public void plus() {
            i++;
        }

        public int getNumber() {
            return i;
        }

        public void reset() {
            i = 0;
        }
    }

    public class YmlConfig {
        private String springDatasourceDriverClassName;
    }


    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Warn {
        private String path;
        private int line;
        private String keyWord;
        private String suggest;
    }

}
