package com.zjty.inspect.controller;

import com.zjty.inspect.entity.ReportVo;
import com.zjty.inspect.service.ReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 报告
 * @author Mcj
 * @date 2020-02-27 09:58
 */
@RequestMapping("/report")
@RestController
public class ReportController {

    @Autowired
    private ReportService reportService;
    /**
     * 历史报告查看
     * @return 历史报告
     */
    @GetMapping
    public ResponseEntity history(){
        List<ReportVo> history = reportService.getHistory();
        return ResponseEntity.ok(history);
    }
}
