package com.zjty.inspect.controller;

import com.zjty.inspect.entity.TechnologyQo;
import com.zjty.inspect.service.TechnologyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * 适配技术
 * @author Mcj
 * @date 2020-02-29 16:10
 */

@RequestMapping("/technology")
@RestController
public class TechnologyController {

    @Autowired
    private TechnologyService technologyService;

    /**
     * 获取所有关键技术
     * @return List
     */
    @GetMapping
    public ResponseEntity getTechnologies(){
        return ResponseEntity.ok(technologyService.findAllTechnology());
    }

    /**
     * 添加关键技术
     * @return List
     */
    @PostMapping
    public ResponseEntity addTechnologies(@RequestBody TechnologyQo technologyQo){
        technologyService.addAdvice(technologyQo);
        return ResponseEntity.ok(200);
    }
}
