package com.zjty.inspect.service.impl;

import com.zjty.inspect.entity.InspectParameter;
import com.zjty.inspect.entity.Report;
import com.zjty.inspect.entity.ReportVo;
import com.zjty.inspect.enums.Language;
import com.zjty.inspect.service.InspectService;
import com.zjty.inspect.inspect.Inspector;
import freemarker.cache.StringTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * 解析
 * @author mcj
 */
@Service
public class InspectServiceImpl implements InspectService {

    @Autowired
    Inspector inspector;

    @Transactional
    @Override
    public ReportVo inspect(ReportVo reportVo,InspectParameter inspectParameter) {
        //统计文件后缀数量
        Map<String, Language> suffixLanguageMapping = new HashMap<>();
        suffixLanguageMapping.put("java", Language.JAVA);
        suffixLanguageMapping.put("vue", Language.VUE);
        suffixLanguageMapping.put("cpp", Language.CPP);
        suffixLanguageMapping.put("py", Language.PYTHON);
        suffixLanguageMapping.put("jsp", Language.JAVA);
        suffixLanguageMapping.put("go", Language.GO);
        suffixLanguageMapping.put("js", Language.JAVASCRIPT);
        suffixLanguageMapping.put("html", Language.HTML);
        //构造成员变量
        inspector.setInspectParameter(inspectParameter);
        //构造报告vo
        inspector.setReport(reportVo);
        //需要重构
        inspector.setSuffixLanguageMapping(suffixLanguageMapping);
        ReportVo report = inspector.inspect();



        return report;
    }

    //执行静态化
    public String generateHtml(String templateContent,Map model ){
        //创建配置对象
        Configuration configuration = new Configuration(Configuration.getVersion());
        //创建模板加载器
        StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
        stringTemplateLoader.putTemplate("template",templateContent);
        //向configuration配置模板加载器
        configuration.setTemplateLoader(stringTemplateLoader);
        //获取模板
        try {
            Template template = configuration.getTemplate("template");
            //调用api进行静态化
            String content = FreeMarkerTemplateUtils.processTemplateIntoString(template, model);
            return content;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }
}
