package com.zjty.inspect.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.persistence.Column;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * @author Mcj
 */
@Data
public class ReportVo {

    private String id;
    /**
     * 文件名称
     */
    private String fileName;
    /**
     * 项目名称
     */
    private String projectName;
    /**
     * 上传类型
     */
    private String uploadType;
    /**
     * git源代码地址
     */
    private String gitAddress;

    /**
     * 架构，整合型还是分离型，根据jsp数量决定
     */
    private String framework;

    /**
     * 代码管理方式，
     */
    private String manager;

    /**
     * 数据库类型
     */
    private String databaseType;

    /**
     * 语言
     */
    private String language;

    /**
     * 生成报告存储地址
     */
    private String htmlAddress;

    /**
     * 适配方式
     * 1：适配
     * 2：重构
     */
    @Column(length = 5)
    private String recastMethod;

    /**
     * 源代码地址
     */
    private String sourceAddress;

    /**
     * 预算详情
     */
    private List<Budget> budgets;

    /**
     * 依赖
     */
    private DependencyVo dependencyVo;

    /**
     * 匹配技术列表
     */
    private List<Technology> technologies;

    private HashMap<String,Technology> technologyNameMap = new HashMap<>();
    /**
     * 告警点
     */
    private HashMap<String, List<Warn>> warnDetails;

    /**
     * 评估时间
     */
    @JsonFormat(pattern = "YYYY-MM-dd",timezone="GMT+8")
    private Date createDate = new Date();
}
