package com.zjty.inspect.service.impl;

import com.zjty.inspect.entity.InspectParameter;
import com.zjty.inspect.entity.Report;
import com.zjty.inspect.entity.ReportVo;
import com.zjty.inspect.service.InspectService;
import com.zjty.inspect.inspect.Inspector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.Map;

/**
 * 解析
 * @author mcj
 */
@Service
public class InspectServiceImpl implements InspectService {

    @Autowired
    Inspector inspector;


    @Transactional
    @Override
    public ReportVo inspect(ReportVo reportVo,InspectParameter inspectParameter) {
        //统计文件后缀数量
        Map<String, Report.Language> suffixLanguageMapping = new HashMap<>();
        suffixLanguageMapping.put("java", Report.Language.JAVA);
        suffixLanguageMapping.put("vue", Report.Language.VUE);
        suffixLanguageMapping.put("cpp", Report.Language.CPP);
        suffixLanguageMapping.put("py", Report.Language.PYTHON);
        suffixLanguageMapping.put("jsp", Report.Language.JAVA);
        suffixLanguageMapping.put("go", Report.Language.GO);
        suffixLanguageMapping.put("js", Report.Language.JAVASCRIPT);
        suffixLanguageMapping.put("html", Report.Language.HTML);
        //构造成员变量
        inspector.setInspectParameter(inspectParameter);
        //构造报告vo
        inspector.setReport(reportVo);
        //需要重构
        inspector.setSuffixLanguageMapping(suffixLanguageMapping);
        ReportVo report = inspector.inspect();

        return report;
    }
}
