package com.zjty.inspect.entity;

import lombok.Data;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import java.sql.Timestamp;

/**
 * 预算
 * @author Mcj
 * @date 2020-02-27 19:05
 */

@Data
@Entity
public class Budget {
    @Id
    private String id;

    /**
     * 代码重构预算、代码修改预算、
     */
    private String budgetName;
    /**
     * 资金
     */
    private String fund;

    /**
     * 资金详情
     */
    private String fundDetail;

    /**
     * 关键报告id
     */
    private String reportId;

    /**
     * 数据创建时间
     */
    @Column(name="create_time",columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP",insertable = false,updatable = false)
    @Generated(GenerationTime.INSERT)
    private Timestamp createDate;

    /**
     * 数据更新时间
     */
    @Column(name="update_time",columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP",insertable = false)
    @Generated(GenerationTime.ALWAYS)
    private Timestamp updateDate;
}
