package com.zjty.inspect.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.Id;
import java.util.ArrayList;
import java.util.List;

/**
 * 传入参数，需要保存
 * @author Mcj
 * @date 2020-02-12 12:35
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
public class InspectParameter {

    @Id
    private String id;

    /**
     *  重构占比
     */
    private Double proportion;

    /**
     * 年利率
     */
    private Double moneyRate;

    /**
     * 软件开发时间
     */
    private Integer years;

    /**
     * 原系统费用
     */
    private Integer systemFund;

    /**
     * 模块数
     */
    private Integer modules;

    /**
     * 每页预算
     */
    private Integer pageBudget;

    /**
     * 数据量
     */
    private Integer data;

    /**
     * 架构
     */
    private Double framework;

    /**
     * 安全能力
     * 1：无
     * 2：弱
     * 3：强
     */
    private Double safety;

    /**
     * 容灾
     * 1：无0，有+0.05
     * 2：有0，无-0.05
     * 3：有0，无-0.1
     */
    private Double disaster;

}
