package com.zjty.inspect.entity;

import lombok.Data;

import javax.persistence.Column;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @author Mcj
 */
@Data
public class ReportVo {
    /**
     * 主键id uuid
     */
    private String id;

    /**
     * git源代码地址
     */
    private String gitAddress;

    /**
     * 架构，整合型还是分离型，根据jsp数量决定
     */
    private String framework;

    /**
     * 代码管理方式，
     */
    private String manager;

    /**
     * 语言
     */
    private String language;

    /**
     * 生成报告存储地址
     */
    private String htmlAddress;

    /**
     * 适配方式
     * 1：适配
     * 2：重构
     */
    @Column(length = 5)
    private Integer recastMethod;

    /**
     * 预算详情
     */
    private List<Budget> budgets;

    /**
     * 依赖
     */
    private DepTreeVo depTreeVo;

    /**
     * 匹配技术列表
     */
    private List<TechnologyVo> technologyVos;

    /**
     * 告警点
     */
    private HashMap<String, ArrayList<RuleAndReportVo>> warnDetails;

    /**
     * 关键技术数量
     */
    private Integer warnNum;
}
