package com.zjty.inspect.service.impl;

import com.zjty.inspect.dao.ReportDao;
import com.zjty.inspect.dao.RuleDao;
import com.zjty.inspect.entity.InspectParameter;
import com.zjty.inspect.entity.Report;
import com.zjty.inspect.entity.Rule;
import com.zjty.inspect.service.InspectService;
import com.zjty.inspect.service.ParameterService;
import com.zjty.inspect.utils.Inspector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 解析
 * @author mcj
 */
@Service
public class InspectServiceImpl implements InspectService {

    @Autowired
    Inspector inspector;

    @Autowired
    private ParameterService parameterService;

    @Autowired
    private RuleDao ruleDao;

    @Autowired
    private ReportDao reportDao;

    @Transactional
    @Override
    public Report inspect(InspectParameter inspectParameter,String path) {
        Map<String, Report.Language> suffixLanguageMapping = new HashMap<>();
        suffixLanguageMapping.put("java", Report.Language.JAVA);
        suffixLanguageMapping.put("vue", Report.Language.VUE);
        suffixLanguageMapping.put("cpp", Report.Language.CPP);
        suffixLanguageMapping.put("py", Report.Language.PYTHON);
        suffixLanguageMapping.put("jsp", Report.Language.JSP);
        suffixLanguageMapping.put("html", Report.Language.ONLYVIEW);
        suffixLanguageMapping.put("js", Report.Language.JAVASCRIPT);
        suffixLanguageMapping.put("go", Report.Language.GO);
        Path path1 = Paths.get(path);
        File file = path1.toFile();
        Report report1 = new Report();
        report1.setGitAddress(path);
        inspector.setReport(report1);
        inspector.setSuffixLanguageMapping(suffixLanguageMapping);
        inspector.setPath(path);
        Report report = inspector.inspect();
        reportDao.save(report);
        return null;
    }
    public void listfile(String path,Map<String, Report.Language> suffixLanguageMapping,List<Rule> ruleList){
        Path path1 = Paths.get(path);
        File file = path1.toFile();
        File[] files = file.listFiles();
        System.out.println(file.isDirectory());
        for (File file1 : files) {
           // Report report = new Inspector(file1.getPath(), suffixLanguageMapping, ruleList).inspect();


        }
    }
    public Report notList(String path,Map<String, Report.Language> suffixLanguageMapping,List<Rule> ruleList){
        Path path1 = Paths.get(path);
        File file = path1.toFile();
        //File file2 = new File(file.getPath() + "/评估报告" + file.getName() + ".txt");
//        if (file2.exists()){
//            file2.delete();
//
//        }
       // Report report = new Inspector(file.getPath(), suffixLanguageMapping, ruleList).inspect();


        return new Report();
    }
}
