package com.zjty.inspect.task;

import com.zjty.inspect.dao.CoefficientModelDao;
import com.zjty.inspect.dao.RuleDao;
import com.zjty.inspect.dao.TechnologyDao;
import com.zjty.inspect.entity.CoefficientModel;
import com.zjty.inspect.entity.Rule;
import com.zjty.inspect.entity.Technology;
import com.zjty.inspect.utils.UUIDUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * @author Mcj
 * @date 2020-03-02 14:35
 */

@Component
public class task implements CommandLineRunner {

    @Autowired
    private CoefficientModelDao coefficientModelDao;

    @Autowired
    private RuleDao ruleDao;

    @Autowired
    private TechnologyDao technologyDao;



    @Override
    public void run(String... args) {
        ArrayList<CoefficientModel> coefficientModels = new ArrayList<>();
        //无，弱，强
        CoefficientModel coefficientModel = new CoefficientModel();
        coefficientModel.setScale(1);
        coefficientModel.setId(UUIDUtil.getUUID());
        coefficientModel.setName("安全能力");
        coefficientModel.setMin(0);
        coefficientModel.setMax(2);
        coefficientModel.setBelowCoefficient(0D);
        coefficientModel.setMediumCoefficient(0.1);
        coefficientModel.setTopCoefficient(0.2);

        CoefficientModel coefficientMode2 = new CoefficientModel();
        coefficientMode2.setScale(2);
        coefficientMode2.setId(UUIDUtil.getUUID());
        coefficientMode2.setName("安全能力");
        coefficientMode2.setMin(0);
        coefficientMode2.setMax(2);
        coefficientMode2.setBelowCoefficient(-0.1);
        coefficientMode2.setMediumCoefficient(0D);
        coefficientMode2.setTopCoefficient(0.1);

        CoefficientModel coefficientMode3 = new CoefficientModel();
        coefficientMode3.setScale(3);
        coefficientMode3.setId(UUIDUtil.getUUID());
        coefficientMode3.setName("安全能力");
        coefficientMode3.setMin(0);
        coefficientMode3.setMax(2);
        coefficientMode3.setBelowCoefficient(-0.2);
        coefficientMode3.setMediumCoefficient(-0.1);
        coefficientMode3.setTopCoefficient(0D);

        CoefficientModel coefficientMode4 = new CoefficientModel();
        coefficientMode4.setScale(1);
        coefficientMode4.setId(UUIDUtil.getUUID());
        coefficientMode4.setName("模块");
        coefficientMode4.setMin(4);
        coefficientMode4.setMax(10);
        coefficientMode4.setBelowCoefficient(-0.3);
        coefficientMode4.setMediumCoefficient(0D);
        coefficientMode4.setTopCoefficient(0.3);

        CoefficientModel coefficientMode5 = new CoefficientModel();
        coefficientMode5.setScale(1);
        coefficientMode5.setId(UUIDUtil.getUUID());
        coefficientMode5.setName("数据量");
        coefficientMode5.setMin(1);
        coefficientMode5.setMax(100);
        coefficientMode5.setBelowCoefficient(-0.05);
        coefficientMode5.setMediumCoefficient(0D);
        coefficientMode5.setTopCoefficient(0.05);

        CoefficientModel coefficientMode6 = new CoefficientModel();
        coefficientMode6.setScale(1);
        coefficientMode6.setId(UUIDUtil.getUUID());
        coefficientMode6.setName("页面数");
        coefficientMode6.setMin(10);
        coefficientMode6.setMax(100);
        coefficientMode6.setBelowCoefficient(-0.05);
        coefficientMode6.setMediumCoefficient(0D);
        coefficientMode6.setTopCoefficient(0.05);
        coefficientModels.add(coefficientMode6);
        coefficientModels.add(coefficientMode5);
        coefficientModels.add(coefficientMode4);
        coefficientModels.add(coefficientMode3);
        coefficientModels.add(coefficientMode2);
        coefficientModels.add(coefficientModel);
        coefficientModelDao.saveAll(coefficientModels);

        Technology technology = new Technology();
        technology.setTechnologyName("spring技术");
        technology.setAdvice("建议替换成国产化技术");
        technology.setFund(200);
        technology.setId(UUIDUtil.getUUID());

        Rule rule = new Rule();
        rule.setId(UUIDUtil.getUUID());
        rule.setSuffix("java");
        rule.setTarget("ruleService");
        rule.setTechnologyId(technology.getId());

        technologyDao.save(technology);
        ruleDao.save(rule);
    }
}
