package com.zjty.inspect.utils;

import com.alibaba.fastjson.JSONObject;
import com.zjty.inspect.dao.TechnologyAndReportDao;
import com.zjty.inspect.entity.*;
import com.zjty.inspect.entity.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.*;

@Component
public class AnalysisFile {

    @Autowired
    private TechnologyAndReportDao technologyAndReportDao;

    public static List<PomDependency> analysisGradle(Path pomPath) {
        List<String> strings = null;
        try {
            strings = Files.readAllLines(pomPath);
        } catch (IOException e) {
            e.printStackTrace();
        }
        List<PomDependency> dependencies = new ArrayList<>();
        for (String string : strings) {
            if(string.indexOf("compile")>0){
                PomDependency pomDependency = new PomDependency();
                int compile = string.indexOf("compile");
                int i = compile + 8;
                String substring = string.substring(i);
                pomDependency.setGradle(substring);
                dependencies.add(pomDependency);
            }
        }
        return dependencies;
    }

    public DepTreePom parseTreeFile(String reportId,String filePath, List<Rule> ruleList) {
        ArrayList<TechnologyAndReport> technologyAndReports = new ArrayList<>();
        Path path = Paths.get(filePath);
        DepTreePom depTreePom = new DepTreePom();
        HashMap<Integer, DepTree> map = new HashMap<>();
        int one = 1;
        DepTree depTree = new DepTree();
        depTreePom.setDepTree(depTree);
        try {
            List<String> strings = Files.readAllLines(path);
            String s1 = strings.get(0);
            depTree.setDepName(s1);
            map.put(0,depTree);
            System.out.println(strings.size());
            int now = 0;
            for (int i = 1; i <= strings.size()-1; i++) {
                DepTree depTree1 = new DepTree();
                System.out.println(i);
                String s = strings.get(i);
                for (Rule rule : ruleList) {
                    if(KmpUtil.kmpMatch(s,rule.getTarget())>0){
                        depTree1.setViolation(1);
                        depTreePom.add(rule.getTechnologyId());
                        //rule匹配上了
                        TechnologyAndReport technologyAndReport = new TechnologyAndReport();
                        technologyAndReport.setFilePath(filePath);
                        technologyAndReport.setLineNum(i);
                        technologyAndReport.setTechnologyId(rule.getTechnologyId());
                        technologyAndReport.setReportId(reportId);
                        technologyAndReport.setRuleId(rule.getId());
                        technologyAndReport.setId(UUIDUtil.getUUID());
                        technologyAndReports.add(technologyAndReport);
                    }
                }
                int i1 = s.indexOf("-");
                if(i1==one){
                    depTree1.setDepName(s);
                    depTree.getDepTreeList().add(depTree1);
                }else{
                    if(i1>now){
                        depTree1.setDepName(s);
                        map.get(i1).getDepTreeList().add(depTree1);
                    }else{
                        depTree1.setDepName(s);
                        map.get(i1).getDepTreeList().add(depTree1);
                    }
                }
                map.put(i1+3,depTree1);
                now = i1;
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        technologyAndReportDao.saveAll(technologyAndReports);
        return depTreePom;
    }


}
