package com.zjty.inspect.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * <h4>Description : 应用类型</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2020-03-05 16:54
 */
@Getter
public enum ApplicationType {
    OA(0,"办公OA应用类"),
    MENHU(1,"门户、信息发布、综合入口服务类"),
    CAIGOU(2,"采购、招投标等采购管理服务类"),
    XM(3,"项目建设跟踪、过程管理等项目管理服务类"),
    KG(4,"库管、资产、自然资源、空间等资产分配管理服务类"),
    CW(5,"财务、审计、税务等财税服务类"),
    HYTJ(6,"行业统计、发布等统计服务类"),
    RYSJ(7,"人员、事件、案件、空间等台账管理服务类"),
    SBTBSP(8,"申报、填报、审批等公共行政服务类"),
    OTHERWINDOWS(9,"其他重要窗口服务类"),
    WENYIN(10,"文印、印刷、制版、排版等工具类"),
    MAIL(11,"邮件、FTP、云盘、ICQ等在线传输工具类"),
    GIS(12,"地图、定位等GIS服务类"),
    THRED(13,"3D、模型等视觉建模应用类"),
    VIDEO(14,"视频、图形等流媒体应用类"),
    NET(15,"网络安全等常规安管应用类"),
    baomi(16,"保密监管等特种安全应用类"),
    SUANFA(17,"提供给行业的算法、API、库、组件、插件等功能型接口类"),
    JISJ(18,"信息化计算资源、存储资源、网络资源等分配管理应用类"),
    ANFANG(19,"信息化基础设施、机房设施、安防设施等分配管理应用类"),
    DATASJI(20,"数据收集、分析、态势感知等大数据应用类"),
    XINHAOJIESHOU(21,"信号接收、中继、转发等信号处理平台"),
    ZHIHUI(22,"多信源、多信道、多流程的指挥调度类平台"),
    DIAODU(23,"多信源、多信道、多流程的监控调度类平台"),
    XIAOXIN(24,"具备上述多项功能的小型平台"),
    ZHONXIN(25,"具备上述多项功能的中型平台"),
    DAXIN(26,"具备上述多项功能的特大型平台"),
    NONE(-1,"无")
    ;

    private Integer code;
    private String name;
    private Integer other;

    ApplicationType() {
    }

    ApplicationType(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    private static Map<String,ApplicationType> applicationTypeHashMap=new HashMap<>();
    private static Map<Integer,ApplicationType> applicationTypeCodeHashMap=new HashMap<>();
    static {
        for (ApplicationType applicationType : ApplicationType.values()) {
            applicationTypeHashMap.put(applicationType.name,applicationType);
            applicationTypeCodeHashMap.put(applicationType.code,applicationType);
        }
    }
    public static ApplicationType getByName(String name){
        ApplicationType applicationType = applicationTypeHashMap.get(name);
        if(applicationType==null){
            return NONE;
        }
        return applicationType;
    }
    public static ApplicationType getByCode(Integer code){
        ApplicationType applicationType = applicationTypeCodeHashMap.get(code);
        if(applicationType==null){
            return NONE;
        }
        return applicationType;
    }

}
