package com.zjty.inspect.config;

import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * @author Mcj
 * @date 2020-03-16 10:33
 */
@ControllerAdvice
@Slf4j
public class ExceptionHandlerConfig {

    @ExceptionHandler(value = HttpMessageNotReadableException.class)
    public ResponseEntity defaultErrorHandler(Exception e) {
        log.error("异常{}",e);
        return ResponseEntity.badRequest().build();
    }
    @ExceptionHandler(value = IOException.class)
    public ResponseEntity defaultIOHandler(Exception e) {
        log.error("IO异常{}",e);
        return ResponseEntity.status(500).build();
    }
}
