package com.zjty.inspect.enums;

import io.swagger.annotations.ApiModel;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@ApiModel(value = "C/S前端开发技术或框架（B/S应用不需要填）")
@Getter
public enum CSTechnologyEnum {
    BUSHEJI(1,"不涉及"),
    WU(-1,"无"),
    C(2,"VC/C++/C#"),
    VB(3,"VB"),
    DELPHI(4,"Delphi"),
    GO(5,"Go"),
    QT(6,"QT"),
    JVM(7,"JVM"),
    NODEJS(8,"Node JS"),
    JAVAAPPLET(9,"Java Applet"),
    QITA(10,"其他：请在备注中填写,如需填写多个,请以逗号分隔");
    private Integer code;
    private String name;

    private static Map<String,CSTechnologyEnum> csTechnologyEnumMap=new HashMap<>();
    private static Map<Integer,CSTechnologyEnum> csTechnologyEnumCodeMap=new HashMap<>();

    static {
        for (CSTechnologyEnum csTechnologyEnum : CSTechnologyEnum.values()) {
            csTechnologyEnumMap.put(csTechnologyEnum.getName(),csTechnologyEnum);
            csTechnologyEnumCodeMap.put(csTechnologyEnum.getCode(),csTechnologyEnum);
        }
    }

    CSTechnologyEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static CSTechnologyEnum getByName(String name){
        CSTechnologyEnum csTechnologyEnum = csTechnologyEnumMap.get(name);
        return csTechnologyEnum;
    }
    public static CSTechnologyEnum getByCode(Integer code){
        CSTechnologyEnum csTechnologyEnum = csTechnologyEnumCodeMap.get(code);
        return csTechnologyEnum;
    }
}
