package com.zjty.inspect.dao;

import com.zjty.inspect.entity.Evaluation;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

public interface EvaluationDao extends JpaRepository<Evaluation,String>, JpaSpecificationExecutor<Evaluation> {
    Evaluation findByUsernameAndIdNot(String username,String id);
    Evaluation findByUsername(String username);
    @Query(value = "SELECT * FROM evaluation WHERE username=:username AND create_time = (SELECT MAX(create_time) FROM evaluation WHERE username=:username)",nativeQuery = true)
    Evaluation findByUsernameAndMaxCreateDate(String username);

}
